package apds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateMigrationJob invokes the apds.CreateMigrationJob API synchronously
func (client *Client) CreateMigrationJob(request *CreateMigrationJobRequest) (response *CreateMigrationJobResponse, err error) {
	response = CreateCreateMigrationJobResponse()
	err = client.DoAction(request, response)
	return
}

// CreateMigrationJobWithChan invokes the apds.CreateMigrationJob API asynchronously
func (client *Client) CreateMigrationJobWithChan(request *CreateMigrationJobRequest) (<-chan *CreateMigrationJobResponse, <-chan error) {
	responseChan := make(chan *CreateMigrationJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateMigrationJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateMigrationJobWithCallback invokes the apds.CreateMigrationJob API asynchronously
func (client *Client) CreateMigrationJobWithCallback(request *CreateMigrationJobRequest, callback func(response *CreateMigrationJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateMigrationJobResponse
		var err error
		defer close(result)
		response, err = client.CreateMigrationJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateMigrationJobRequest is the request struct for api CreateMigrationJob
type CreateMigrationJobRequest struct {
	*requests.RoaRequest
	Body string `position:"Body" name:"body"`
}

// CreateMigrationJobResponse is the response struct for api CreateMigrationJob
type CreateMigrationJobResponse struct {
	*responses.BaseResponse
	Code    string `json:"Code" xml:"Code"`
	Error   string `json:"Error" xml:"Error"`
	Success bool   `json:"Success" xml:"Success"`
	Data    string `json:"Data" xml:"Data"`
}

// CreateCreateMigrationJobRequest creates a request to invoke CreateMigrationJob API
func CreateCreateMigrationJobRequest() (request *CreateMigrationJobRequest) {
	request = &CreateMigrationJobRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("apds", "2022-03-31", "CreateMigrationJob", "/okss-services/migration-job/create-migration-jobs", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateMigrationJobResponse creates a response to parse from CreateMigrationJob response
func CreateCreateMigrationJobResponse() (response *CreateMigrationJobResponse) {
	response = &CreateMigrationJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
