package alinlp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ADMiniCogResult invokes the alinlp.ADMiniCogResult API synchronously
func (client *Client) ADMiniCogResult(request *ADMiniCogResultRequest) (response *ADMiniCogResultResponse, err error) {
	response = CreateADMiniCogResultResponse()
	err = client.DoAction(request, response)
	return
}

// ADMiniCogResultWithChan invokes the alinlp.ADMiniCogResult API asynchronously
func (client *Client) ADMiniCogResultWithChan(request *ADMiniCogResultRequest) (<-chan *ADMiniCogResultResponse, <-chan error) {
	responseChan := make(chan *ADMiniCogResultResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ADMiniCogResult(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ADMiniCogResultWithCallback invokes the alinlp.ADMiniCogResult API asynchronously
func (client *Client) ADMiniCogResultWithCallback(request *ADMiniCogResultRequest, callback func(response *ADMiniCogResultResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ADMiniCogResultResponse
		var err error
		defer close(result)
		response, err = client.ADMiniCogResult(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ADMiniCogResultRequest is the request struct for api ADMiniCogResult
type ADMiniCogResultRequest struct {
	*requests.RpcRequest
	Params      string `position:"Body" name:"Params"`
	ServiceCode string `position:"Body" name:"ServiceCode"`
}

// ADMiniCogResultResponse is the response struct for api ADMiniCogResult
type ADMiniCogResultResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateADMiniCogResultRequest creates a request to invoke ADMiniCogResult API
func CreateADMiniCogResultRequest() (request *ADMiniCogResultRequest) {
	request = &ADMiniCogResultRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("alinlp", "2020-06-29", "ADMiniCogResult", "alinlp", "openAPI")
	request.Method = requests.POST
	return
}

// CreateADMiniCogResultResponse creates a response to parse from ADMiniCogResult response
func CreateADMiniCogResultResponse() (response *ADMiniCogResultResponse) {
	response = &ADMiniCogResultResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
