package alb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateListenerAttribute invokes the alb.UpdateListenerAttribute API synchronously
func (client *Client) UpdateListenerAttribute(request *UpdateListenerAttributeRequest) (response *UpdateListenerAttributeResponse, err error) {
	response = CreateUpdateListenerAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateListenerAttributeWithChan invokes the alb.UpdateListenerAttribute API asynchronously
func (client *Client) UpdateListenerAttributeWithChan(request *UpdateListenerAttributeRequest) (<-chan *UpdateListenerAttributeResponse, <-chan error) {
	responseChan := make(chan *UpdateListenerAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateListenerAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateListenerAttributeWithCallback invokes the alb.UpdateListenerAttribute API asynchronously
func (client *Client) UpdateListenerAttributeWithCallback(request *UpdateListenerAttributeRequest, callback func(response *UpdateListenerAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateListenerAttributeResponse
		var err error
		defer close(result)
		response, err = client.UpdateListenerAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateListenerAttributeRequest is the request struct for api UpdateListenerAttribute
type UpdateListenerAttributeRequest struct {
	*requests.RpcRequest
	ClientToken         string                                     `position:"Query" name:"ClientToken"`
	GzipEnabled         requests.Boolean                           `position:"Query" name:"GzipEnabled"`
	ListenerId          string                                     `position:"Query" name:"ListenerId"`
	QuicConfig          UpdateListenerAttributeQuicConfig          `position:"Query" name:"QuicConfig"  type:"Struct"`
	Http2Enabled        requests.Boolean                           `position:"Query" name:"Http2Enabled"`
	DefaultActions      *[]UpdateListenerAttributeDefaultActions   `position:"Query" name:"DefaultActions"  type:"Repeated"`
	DryRun              requests.Boolean                           `position:"Query" name:"DryRun"`
	RequestTimeout      requests.Integer                           `position:"Query" name:"RequestTimeout"`
	CaCertificates      *[]UpdateListenerAttributeCaCertificates   `position:"Query" name:"CaCertificates"  type:"Repeated"`
	XForwardedForConfig UpdateListenerAttributeXForwardedForConfig `position:"Query" name:"XForwardedForConfig"  type:"Struct"`
	SecurityPolicyId    string                                     `position:"Query" name:"SecurityPolicyId"`
	IdleTimeout         requests.Integer                           `position:"Query" name:"IdleTimeout"`
	Certificates        *[]UpdateListenerAttributeCertificates     `position:"Query" name:"Certificates"  type:"Repeated"`
	ListenerDescription string                                     `position:"Query" name:"ListenerDescription"`
	CaEnabled           requests.Boolean                           `position:"Query" name:"CaEnabled"`
}

// UpdateListenerAttributeDefaultActions is a repeated param struct in UpdateListenerAttributeRequest
type UpdateListenerAttributeDefaultActions struct {
	ForwardGroupConfig UpdateListenerAttributeDefaultActionsForwardGroupConfig `name:"ForwardGroupConfig" type:"Struct"`
	Type               string                                                  `name:"Type"`
}

// UpdateListenerAttributeCaCertificates is a repeated param struct in UpdateListenerAttributeRequest
type UpdateListenerAttributeCaCertificates struct {
	CertificateId string `name:"CertificateId"`
}

// UpdateListenerAttributeCertificates is a repeated param struct in UpdateListenerAttributeRequest
type UpdateListenerAttributeCertificates struct {
	CertificateId string `name:"CertificateId"`
}

// UpdateListenerAttributeDefaultActionsForwardGroupConfig is a repeated param struct in UpdateListenerAttributeRequest
type UpdateListenerAttributeDefaultActionsForwardGroupConfig struct {
	ServerGroupTuples *[]UpdateListenerAttributeDefaultActionsForwardGroupConfigServerGroupTuplesItem `name:"ServerGroupTuples" type:"Repeated"`
}

// UpdateListenerAttributeDefaultActionsForwardGroupConfigServerGroupTuplesItem is a repeated param struct in UpdateListenerAttributeRequest
type UpdateListenerAttributeDefaultActionsForwardGroupConfigServerGroupTuplesItem struct {
	ServerGroupId string `name:"ServerGroupId"`
}

// UpdateListenerAttributeQuicConfig is a repeated param struct in UpdateListenerAttributeRequest
type UpdateListenerAttributeQuicConfig struct {
	QuicUpgradeEnabled string `name:"QuicUpgradeEnabled"`
	QuicListenerId     string `name:"QuicListenerId"`
}

// UpdateListenerAttributeXForwardedForConfig is a repeated param struct in UpdateListenerAttributeRequest
type UpdateListenerAttributeXForwardedForConfig struct {
	XForwardedForClientSourceIpsTrusted        string `name:"XForwardedForClientSourceIpsTrusted"`
	XForwardedForClientCertSubjectDNAlias      string `name:"XForwardedForClientCertSubjectDNAlias"`
	XForwardedForClientSourceIpsEnabled        string `name:"XForwardedForClientSourceIpsEnabled"`
	XForwardedForClientCertIssuerDNEnabled     string `name:"XForwardedForClientCertIssuerDNEnabled"`
	XForwardedForHostEnabled                   string `name:"XForwardedForHostEnabled"`
	XForwardedForProcessingMode                string `name:"XForwardedForProcessingMode"`
	XForwardedForClientCertFingerprintEnabled  string `name:"XForwardedForClientCertFingerprintEnabled"`
	XForwardedForClientCertIssuerDNAlias       string `name:"XForwardedForClientCertIssuerDNAlias"`
	XForwardedForProtoEnabled                  string `name:"XForwardedForProtoEnabled"`
	XForwardedForClientCertFingerprintAlias    string `name:"XForwardedForClientCertFingerprintAlias"`
	XForwardedForClientCertClientVerifyEnabled string `name:"XForwardedForClientCertClientVerifyEnabled"`
	XForwardedForSLBPortEnabled                string `name:"XForwardedForSLBPortEnabled"`
	XForwardedForClientCertSubjectDNEnabled    string `name:"XForwardedForClientCertSubjectDNEnabled"`
	XForwardedForClientCertClientVerifyAlias   string `name:"XForwardedForClientCertClientVerifyAlias"`
	XForwardedForClientSrcPortEnabled          string `name:"XForwardedForClientSrcPortEnabled"`
	XForwardedForEnabled                       string `name:"XForwardedForEnabled"`
	XForwardedForSLBIdEnabled                  string `name:"XForwardedForSLBIdEnabled"`
}

// UpdateListenerAttributeResponse is the response struct for api UpdateListenerAttribute
type UpdateListenerAttributeResponse struct {
	*responses.BaseResponse
	JobId     string `json:"JobId" xml:"JobId"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateListenerAttributeRequest creates a request to invoke UpdateListenerAttribute API
func CreateUpdateListenerAttributeRequest() (request *UpdateListenerAttributeRequest) {
	request = &UpdateListenerAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alb", "2020-06-16", "UpdateListenerAttribute", "alb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateListenerAttributeResponse creates a response to parse from UpdateListenerAttribute response
func CreateUpdateListenerAttributeResponse() (response *UpdateListenerAttributeResponse) {
	response = &UpdateListenerAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
