package airec

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListMixCategories invokes the airec.ListMixCategories API synchronously
func (client *Client) ListMixCategories(request *ListMixCategoriesRequest) (response *ListMixCategoriesResponse, err error) {
	response = CreateListMixCategoriesResponse()
	err = client.DoAction(request, response)
	return
}

// ListMixCategoriesWithChan invokes the airec.ListMixCategories API asynchronously
func (client *Client) ListMixCategoriesWithChan(request *ListMixCategoriesRequest) (<-chan *ListMixCategoriesResponse, <-chan error) {
	responseChan := make(chan *ListMixCategoriesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListMixCategories(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListMixCategoriesWithCallback invokes the airec.ListMixCategories API asynchronously
func (client *Client) ListMixCategoriesWithCallback(request *ListMixCategoriesRequest, callback func(response *ListMixCategoriesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListMixCategoriesResponse
		var err error
		defer close(result)
		response, err = client.ListMixCategories(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListMixCategoriesRequest is the request struct for api ListMixCategories
type ListMixCategoriesRequest struct {
	*requests.RoaRequest
}

// ListMixCategoriesResponse is the response struct for api ListMixCategories
type ListMixCategoriesResponse struct {
	*responses.BaseResponse
	Code      string       `json:"code" xml:"code"`
	Message   string       `json:"message" xml:"message"`
	RequestId string       `json:"requestId" xml:"requestId"`
	Result    []ResultItem `json:"result" xml:"result"`
}

// CreateListMixCategoriesRequest creates a request to invoke ListMixCategories API
func CreateListMixCategoriesRequest() (request *ListMixCategoriesRequest) {
	request = &ListMixCategoriesRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Airec", "2020-11-26", "ListMixCategories", "/v2/openapi/configurations/mixCategories", "airec", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListMixCategoriesResponse creates a response to parse from ListMixCategories response
func CreateListMixCategoriesResponse() (response *ListMixCategoriesResponse) {
	response = &ListMixCategoriesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
