package airec

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteExperiment invokes the airec.DeleteExperiment API synchronously
func (client *Client) DeleteExperiment(request *DeleteExperimentRequest) (response *DeleteExperimentResponse, err error) {
	response = CreateDeleteExperimentResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteExperimentWithChan invokes the airec.DeleteExperiment API asynchronously
func (client *Client) DeleteExperimentWithChan(request *DeleteExperimentRequest) (<-chan *DeleteExperimentResponse, <-chan error) {
	responseChan := make(chan *DeleteExperimentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteExperiment(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteExperimentWithCallback invokes the airec.DeleteExperiment API asynchronously
func (client *Client) DeleteExperimentWithCallback(request *DeleteExperimentRequest, callback func(response *DeleteExperimentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteExperimentResponse
		var err error
		defer close(result)
		response, err = client.DeleteExperiment(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteExperimentRequest is the request struct for api DeleteExperiment
type DeleteExperimentRequest struct {
	*requests.RoaRequest
	InstanceId   string `position:"Path" name:"instanceId"`
	SceneId      string `position:"Path" name:"sceneId"`
	ExperimentId string `position:"Path" name:"experimentId"`
}

// DeleteExperimentResponse is the response struct for api DeleteExperiment
type DeleteExperimentResponse struct {
	*responses.BaseResponse
	Result    bool   `json:"result" xml:"result"`
	RequestId string `json:"requestId" xml:"requestId"`
}

// CreateDeleteExperimentRequest creates a request to invoke DeleteExperiment API
func CreateDeleteExperimentRequest() (request *DeleteExperimentRequest) {
	request = &DeleteExperimentRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Airec", "2020-11-26", "DeleteExperiment", "/v2/openapi/instances/[instanceId]/scenes/[sceneId]/experiments/[experimentId]", "airec", "openAPI")
	request.Method = requests.DELETE
	return
}

// CreateDeleteExperimentResponse creates a response to parse from DeleteExperiment response
func CreateDeleteExperimentResponse() (response *DeleteExperimentResponse) {
	response = &DeleteExperimentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
