package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyWebLockMachineList invokes the aegis.ModifyWebLockMachineList API synchronously
// api document: https://help.aliyun.com/api/aegis/modifyweblockmachinelist.html
func (client *Client) ModifyWebLockMachineList(request *ModifyWebLockMachineListRequest) (response *ModifyWebLockMachineListResponse, err error) {
	response = CreateModifyWebLockMachineListResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyWebLockMachineListWithChan invokes the aegis.ModifyWebLockMachineList API asynchronously
// api document: https://help.aliyun.com/api/aegis/modifyweblockmachinelist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyWebLockMachineListWithChan(request *ModifyWebLockMachineListRequest) (<-chan *ModifyWebLockMachineListResponse, <-chan error) {
	responseChan := make(chan *ModifyWebLockMachineListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyWebLockMachineList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyWebLockMachineListWithCallback invokes the aegis.ModifyWebLockMachineList API asynchronously
// api document: https://help.aliyun.com/api/aegis/modifyweblockmachinelist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyWebLockMachineListWithCallback(request *ModifyWebLockMachineListRequest, callback func(response *ModifyWebLockMachineListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyWebLockMachineListResponse
		var err error
		defer close(result)
		response, err = client.ModifyWebLockMachineList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyWebLockMachineListRequest is the request struct for api ModifyWebLockMachineList
type ModifyWebLockMachineListRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
	Lang     string `position:"Query" name:"Lang"`
	Uuids    string `position:"Query" name:"Uuids"`
}

// ModifyWebLockMachineListResponse is the response struct for api ModifyWebLockMachineList
type ModifyWebLockMachineListResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyWebLockMachineListRequest creates a request to invoke ModifyWebLockMachineList API
func CreateModifyWebLockMachineListRequest() (request *ModifyWebLockMachineListRequest) {
	request = &ModifyWebLockMachineListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "ModifyWebLockMachineList", "vipaegis", "openAPI")
	return
}

// CreateModifyWebLockMachineListResponse creates a response to parse from ModifyWebLockMachineList response
func CreateModifyWebLockMachineListResponse() (response *ModifyWebLockMachineListResponse) {
	response = &ModifyWebLockMachineListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
