package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSecurityStatInfo invokes the aegis.DescribeSecurityStatInfo API synchronously
// api document: https://help.aliyun.com/api/aegis/describesecuritystatinfo.html
func (client *Client) DescribeSecurityStatInfo(request *DescribeSecurityStatInfoRequest) (response *DescribeSecurityStatInfoResponse, err error) {
	response = CreateDescribeSecurityStatInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSecurityStatInfoWithChan invokes the aegis.DescribeSecurityStatInfo API asynchronously
// api document: https://help.aliyun.com/api/aegis/describesecuritystatinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeSecurityStatInfoWithChan(request *DescribeSecurityStatInfoRequest) (<-chan *DescribeSecurityStatInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeSecurityStatInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSecurityStatInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSecurityStatInfoWithCallback invokes the aegis.DescribeSecurityStatInfo API asynchronously
// api document: https://help.aliyun.com/api/aegis/describesecuritystatinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeSecurityStatInfoWithCallback(request *DescribeSecurityStatInfoRequest, callback func(response *DescribeSecurityStatInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSecurityStatInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeSecurityStatInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSecurityStatInfoRequest is the request struct for api DescribeSecurityStatInfo
type DescribeSecurityStatInfoRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
	Lang     string `position:"Query" name:"Lang"`
}

// DescribeSecurityStatInfoResponse is the response struct for api DescribeSecurityStatInfo
type DescribeSecurityStatInfoResponse struct {
	*responses.BaseResponse
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	Success       bool          `json:"Success" xml:"Success"`
	SecurityEvent SecurityEvent `json:"SecurityEvent" xml:"SecurityEvent"`
	AttackEvent   AttackEvent   `json:"AttackEvent" xml:"AttackEvent"`
	HealthCheck   HealthCheck   `json:"HealthCheck" xml:"HealthCheck"`
	Vulnerability Vulnerability `json:"Vulnerability" xml:"Vulnerability"`
}

// CreateDescribeSecurityStatInfoRequest creates a request to invoke DescribeSecurityStatInfo API
func CreateDescribeSecurityStatInfoRequest() (request *DescribeSecurityStatInfoRequest) {
	request = &DescribeSecurityStatInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "DescribeSecurityStatInfo", "vipaegis", "openAPI")
	return
}

// CreateDescribeSecurityStatInfoResponse creates a response to parse from DescribeSecurityStatInfo response
func CreateDescribeSecurityStatInfoResponse() (response *DescribeSecurityStatInfoResponse) {
	response = &DescribeSecurityStatInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
