package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreatScreenSetting invokes the aegis.CreatScreenSetting API synchronously
// api document: https://help.aliyun.com/api/aegis/creatscreensetting.html
func (client *Client) CreatScreenSetting(request *CreatScreenSettingRequest) (response *CreatScreenSettingResponse, err error) {
	response = CreateCreatScreenSettingResponse()
	err = client.DoAction(request, response)
	return
}

// CreatScreenSettingWithChan invokes the aegis.CreatScreenSetting API asynchronously
// api document: https://help.aliyun.com/api/aegis/creatscreensetting.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreatScreenSettingWithChan(request *CreatScreenSettingRequest) (<-chan *CreatScreenSettingResponse, <-chan error) {
	responseChan := make(chan *CreatScreenSettingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreatScreenSetting(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreatScreenSettingWithCallback invokes the aegis.CreatScreenSetting API asynchronously
// api document: https://help.aliyun.com/api/aegis/creatscreensetting.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreatScreenSettingWithCallback(request *CreatScreenSettingRequest, callback func(response *CreatScreenSettingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreatScreenSettingResponse
		var err error
		defer close(result)
		response, err = client.CreatScreenSetting(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreatScreenSettingRequest is the request struct for api CreatScreenSetting
type CreatScreenSettingRequest struct {
	*requests.RpcRequest
	SourceIp        string `position:"Query" name:"SourceIp"`
	ScreenTitle     string `position:"Query" name:"ScreenTitle"`
	ScreenIdSetting string `position:"Query" name:"ScreenIdSetting"`
}

// CreatScreenSettingResponse is the response struct for api CreatScreenSetting
type CreatScreenSettingResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreatScreenSettingRequest creates a request to invoke CreatScreenSetting API
func CreateCreatScreenSettingRequest() (request *CreatScreenSettingRequest) {
	request = &CreatScreenSettingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "CreatScreenSetting", "vipaegis", "openAPI")
	return
}

// CreateCreatScreenSettingResponse creates a response to parse from CreatScreenSetting response
func CreateCreatScreenSettingResponse() (response *CreatScreenSettingResponse) {
	response = &CreatScreenSettingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
