// Copyright 2020-2024 the Pinniped contributors. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	v1alpha1 "go.pinniped.dev/generated/latest/apis/concierge/config/v1alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeCredentialIssuers implements CredentialIssuerInterface
type FakeCredentialIssuers struct {
	Fake *FakeConfigV1alpha1
}

var credentialissuersResource = v1alpha1.SchemeGroupVersion.WithResource("credentialissuers")

var credentialissuersKind = v1alpha1.SchemeGroupVersion.WithKind("CredentialIssuer")

// Get takes name of the credentialIssuer, and returns the corresponding credentialIssuer object, and an error if there is any.
func (c *FakeCredentialIssuers) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.CredentialIssuer, err error) {
	emptyResult := &v1alpha1.CredentialIssuer{}
	obj, err := c.Fake.
		Invokes(testing.NewRootGetActionWithOptions(credentialissuersResource, name, options), emptyResult)
	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1alpha1.CredentialIssuer), err
}

// List takes label and field selectors, and returns the list of CredentialIssuers that match those selectors.
func (c *FakeCredentialIssuers) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.CredentialIssuerList, err error) {
	emptyResult := &v1alpha1.CredentialIssuerList{}
	obj, err := c.Fake.
		Invokes(testing.NewRootListActionWithOptions(credentialissuersResource, credentialissuersKind, opts), emptyResult)
	if obj == nil {
		return emptyResult, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha1.CredentialIssuerList{ListMeta: obj.(*v1alpha1.CredentialIssuerList).ListMeta}
	for _, item := range obj.(*v1alpha1.CredentialIssuerList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested credentialIssuers.
func (c *FakeCredentialIssuers) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewRootWatchActionWithOptions(credentialissuersResource, opts))
}

// Create takes the representation of a credentialIssuer and creates it.  Returns the server's representation of the credentialIssuer, and an error, if there is any.
func (c *FakeCredentialIssuers) Create(ctx context.Context, credentialIssuer *v1alpha1.CredentialIssuer, opts v1.CreateOptions) (result *v1alpha1.CredentialIssuer, err error) {
	emptyResult := &v1alpha1.CredentialIssuer{}
	obj, err := c.Fake.
		Invokes(testing.NewRootCreateActionWithOptions(credentialissuersResource, credentialIssuer, opts), emptyResult)
	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1alpha1.CredentialIssuer), err
}

// Update takes the representation of a credentialIssuer and updates it. Returns the server's representation of the credentialIssuer, and an error, if there is any.
func (c *FakeCredentialIssuers) Update(ctx context.Context, credentialIssuer *v1alpha1.CredentialIssuer, opts v1.UpdateOptions) (result *v1alpha1.CredentialIssuer, err error) {
	emptyResult := &v1alpha1.CredentialIssuer{}
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateActionWithOptions(credentialissuersResource, credentialIssuer, opts), emptyResult)
	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1alpha1.CredentialIssuer), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeCredentialIssuers) UpdateStatus(ctx context.Context, credentialIssuer *v1alpha1.CredentialIssuer, opts v1.UpdateOptions) (result *v1alpha1.CredentialIssuer, err error) {
	emptyResult := &v1alpha1.CredentialIssuer{}
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateSubresourceActionWithOptions(credentialissuersResource, "status", credentialIssuer, opts), emptyResult)
	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1alpha1.CredentialIssuer), err
}

// Delete takes name of the credentialIssuer and deletes it. Returns an error if one occurs.
func (c *FakeCredentialIssuers) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewRootDeleteActionWithOptions(credentialissuersResource, name, opts), &v1alpha1.CredentialIssuer{})
	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeCredentialIssuers) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewRootDeleteCollectionActionWithOptions(credentialissuersResource, opts, listOpts)

	_, err := c.Fake.Invokes(action, &v1alpha1.CredentialIssuerList{})
	return err
}

// Patch applies the patch and returns the patched credentialIssuer.
func (c *FakeCredentialIssuers) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.CredentialIssuer, err error) {
	emptyResult := &v1alpha1.CredentialIssuer{}
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceActionWithOptions(credentialissuersResource, name, pt, data, opts, subresources...), emptyResult)
	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1alpha1.CredentialIssuer), err
}
