// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package kms

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opRestoreSecretCommon = "RestoreSecret"

// RestoreSecretCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the RestoreSecretCommon operation. The "output" return
// value will be populated with the RestoreSecretCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned RestoreSecretCommon Request to send the API call to the service.
// the "output" return value is not valid until after RestoreSecretCommon Send returns without error.
//
// See RestoreSecretCommon for more information on using the RestoreSecretCommon
// API call, and error handling.
//
//    // Example sending a request using the RestoreSecretCommonRequest method.
//    req, resp := client.RestoreSecretCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) RestoreSecretCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opRestoreSecretCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// RestoreSecretCommon API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation RestoreSecretCommon for usage and error information.
func (c *KMS) RestoreSecretCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.RestoreSecretCommonRequest(input)
	return out, req.Send()
}

// RestoreSecretCommonWithContext is the same as RestoreSecretCommon with the addition of
// the ability to pass a context and additional request options.
//
// See RestoreSecretCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) RestoreSecretCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.RestoreSecretCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRestoreSecret = "RestoreSecret"

// RestoreSecretRequest generates a "volcengine/request.Request" representing the
// client's request for the RestoreSecret operation. The "output" return
// value will be populated with the RestoreSecretCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned RestoreSecretCommon Request to send the API call to the service.
// the "output" return value is not valid until after RestoreSecretCommon Send returns without error.
//
// See RestoreSecret for more information on using the RestoreSecret
// API call, and error handling.
//
//    // Example sending a request using the RestoreSecretRequest method.
//    req, resp := client.RestoreSecretRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) RestoreSecretRequest(input *RestoreSecretInput) (req *request.Request, output *RestoreSecretOutput) {
	op := &request.Operation{
		Name:       opRestoreSecret,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RestoreSecretInput{}
	}

	output = &RestoreSecretOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// RestoreSecret API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation RestoreSecret for usage and error information.
func (c *KMS) RestoreSecret(input *RestoreSecretInput) (*RestoreSecretOutput, error) {
	req, out := c.RestoreSecretRequest(input)
	return out, req.Send()
}

// RestoreSecretWithContext is the same as RestoreSecret with the addition of
// the ability to pass a context and additional request options.
//
// See RestoreSecret for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) RestoreSecretWithContext(ctx volcengine.Context, input *RestoreSecretInput, opts ...request.Option) (*RestoreSecretOutput, error) {
	req, out := c.RestoreSecretRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type RestoreSecretInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// BackupData is a required field
	BackupData *string `type:"string" json:",omitempty" required:"true"`

	// SecretDataKey is a required field
	SecretDataKey *string `type:"string" json:",omitempty" required:"true"`

	// Signature is a required field
	Signature *string `type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s RestoreSecretInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreSecretInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestoreSecretInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RestoreSecretInput"}
	if s.BackupData == nil {
		invalidParams.Add(request.NewErrParamRequired("BackupData"))
	}
	if s.SecretDataKey == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretDataKey"))
	}
	if s.Signature == nil {
		invalidParams.Add(request.NewErrParamRequired("Signature"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupData sets the BackupData field's value.
func (s *RestoreSecretInput) SetBackupData(v string) *RestoreSecretInput {
	s.BackupData = &v
	return s
}

// SetSecretDataKey sets the SecretDataKey field's value.
func (s *RestoreSecretInput) SetSecretDataKey(v string) *RestoreSecretInput {
	s.SecretDataKey = &v
	return s
}

// SetSignature sets the Signature field's value.
func (s *RestoreSecretInput) SetSignature(v string) *RestoreSecretInput {
	s.Signature = &v
	return s
}

type RestoreSecretOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata
}

// String returns the string representation
func (s RestoreSecretOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreSecretOutput) GoString() string {
	return s.String()
}
