// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package escloud

import (
	"fmt"

	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateInstanceInOneStepCommon = "CreateInstanceInOneStep"

// CreateInstanceInOneStepCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateInstanceInOneStepCommon operation. The "output" return
// value will be populated with the CreateInstanceInOneStepCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateInstanceInOneStepCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateInstanceInOneStepCommon Send returns without error.
//
// See CreateInstanceInOneStepCommon for more information on using the CreateInstanceInOneStepCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateInstanceInOneStepCommonRequest method.
//    req, resp := client.CreateInstanceInOneStepCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ESCLOUD) CreateInstanceInOneStepCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateInstanceInOneStepCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateInstanceInOneStepCommon API operation for ESCLOUD.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ESCLOUD's
// API operation CreateInstanceInOneStepCommon for usage and error information.
func (c *ESCLOUD) CreateInstanceInOneStepCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateInstanceInOneStepCommonRequest(input)
	return out, req.Send()
}

// CreateInstanceInOneStepCommonWithContext is the same as CreateInstanceInOneStepCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateInstanceInOneStepCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ESCLOUD) CreateInstanceInOneStepCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateInstanceInOneStepCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateInstanceInOneStep = "CreateInstanceInOneStep"

// CreateInstanceInOneStepRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateInstanceInOneStep operation. The "output" return
// value will be populated with the CreateInstanceInOneStepCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateInstanceInOneStepCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateInstanceInOneStepCommon Send returns without error.
//
// See CreateInstanceInOneStep for more information on using the CreateInstanceInOneStep
// API call, and error handling.
//
//    // Example sending a request using the CreateInstanceInOneStepRequest method.
//    req, resp := client.CreateInstanceInOneStepRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ESCLOUD) CreateInstanceInOneStepRequest(input *CreateInstanceInOneStepInput) (req *request.Request, output *CreateInstanceInOneStepOutput) {
	op := &request.Operation{
		Name:       opCreateInstanceInOneStep,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateInstanceInOneStepInput{}
	}

	output = &CreateInstanceInOneStepOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateInstanceInOneStep API operation for ESCLOUD.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ESCLOUD's
// API operation CreateInstanceInOneStep for usage and error information.
func (c *ESCLOUD) CreateInstanceInOneStep(input *CreateInstanceInOneStepInput) (*CreateInstanceInOneStepOutput, error) {
	req, out := c.CreateInstanceInOneStepRequest(input)
	return out, req.Send()
}

// CreateInstanceInOneStepWithContext is the same as CreateInstanceInOneStep with the addition of
// the ability to pass a context and additional request options.
//
// See CreateInstanceInOneStep for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ESCLOUD) CreateInstanceInOneStepWithContext(ctx volcengine.Context, input *CreateInstanceInOneStepInput, opts ...request.Option) (*CreateInstanceInOneStepOutput, error) {
	req, out := c.CreateInstanceInOneStepRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateInstanceInOneStepInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ClientToken *string `type:"string" json:",omitempty"`

	InstanceConfiguration *InstanceConfigurationForCreateInstanceInOneStepInput `type:"structure" json:",omitempty"`

	Tags []*TagForCreateInstanceInOneStepInput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s CreateInstanceInOneStepInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInstanceInOneStepInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateInstanceInOneStepInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateInstanceInOneStepInput"}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateInstanceInOneStepInput) SetClientToken(v string) *CreateInstanceInOneStepInput {
	s.ClientToken = &v
	return s
}

// SetInstanceConfiguration sets the InstanceConfiguration field's value.
func (s *CreateInstanceInOneStepInput) SetInstanceConfiguration(v *InstanceConfigurationForCreateInstanceInOneStepInput) *CreateInstanceInOneStepInput {
	s.InstanceConfiguration = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateInstanceInOneStepInput) SetTags(v []*TagForCreateInstanceInOneStepInput) *CreateInstanceInOneStepInput {
	s.Tags = v
	return s
}

type CreateInstanceInOneStepOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	InstanceId *string `type:"string" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CreateInstanceInOneStepOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInstanceInOneStepOutput) GoString() string {
	return s.String()
}

// SetInstanceId sets the InstanceId field's value.
func (s *CreateInstanceInOneStepOutput) SetInstanceId(v string) *CreateInstanceInOneStepOutput {
	s.InstanceId = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateInstanceInOneStepOutput) SetName(v string) *CreateInstanceInOneStepOutput {
	s.Name = &v
	return s
}

type ExtraPerformanceForCreateInstanceInOneStepInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Throughput *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s ExtraPerformanceForCreateInstanceInOneStepInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ExtraPerformanceForCreateInstanceInOneStepInput) GoString() string {
	return s.String()
}

// SetThroughput sets the Throughput field's value.
func (s *ExtraPerformanceForCreateInstanceInOneStepInput) SetThroughput(v int32) *ExtraPerformanceForCreateInstanceInOneStepInput {
	s.Throughput = &v
	return s
}

type InstanceConfigurationForCreateInstanceInOneStepInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AdminPassword *string `type:"string" json:",omitempty"`

	AutoRenew *bool `type:"boolean" json:",omitempty"`

	ChargeType *string `type:"string" json:",omitempty" enum:"EnumOfChargeTypeForCreateInstanceInOneStepInput"`

	ConfigurationCode *string `type:"string" json:",omitempty"`

	DeletionProtection *bool `type:"boolean" json:",omitempty"`

	EnableCerebro *bool `type:"boolean" json:",omitempty"`

	EnableHttps *bool `type:"boolean" json:",omitempty"`

	EnablePureMaster *bool `type:"boolean" json:",omitempty"`

	InstanceName *string `type:"string" json:",omitempty"`

	NetworkSpecs []*NetworkSpecForCreateInstanceInOneStepInput `type:"list" json:",omitempty"`

	NodeSpecsAssigns []*NodeSpecsAssignForCreateInstanceInOneStepInput `type:"list" json:",omitempty"`

	Period *int32 `type:"int32" json:",omitempty"`

	ProjectName *string `type:"string" json:",omitempty"`

	RegionId *string `type:"string" json:",omitempty"`

	Subnet *SubnetForCreateInstanceInOneStepInput `type:"structure" json:",omitempty"`

	VPC *VPCForCreateInstanceInOneStepInput `type:"structure" json:",omitempty"`

	Version *string `type:"string" json:",omitempty" enum:"EnumOfVersionForCreateInstanceInOneStepInput"`

	ZoneId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s InstanceConfigurationForCreateInstanceInOneStepInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceConfigurationForCreateInstanceInOneStepInput) GoString() string {
	return s.String()
}

// SetAdminPassword sets the AdminPassword field's value.
func (s *InstanceConfigurationForCreateInstanceInOneStepInput) SetAdminPassword(v string) *InstanceConfigurationForCreateInstanceInOneStepInput {
	s.AdminPassword = &v
	return s
}

// SetAutoRenew sets the AutoRenew field's value.
func (s *InstanceConfigurationForCreateInstanceInOneStepInput) SetAutoRenew(v bool) *InstanceConfigurationForCreateInstanceInOneStepInput {
	s.AutoRenew = &v
	return s
}

// SetChargeType sets the ChargeType field's value.
func (s *InstanceConfigurationForCreateInstanceInOneStepInput) SetChargeType(v string) *InstanceConfigurationForCreateInstanceInOneStepInput {
	s.ChargeType = &v
	return s
}

// SetConfigurationCode sets the ConfigurationCode field's value.
func (s *InstanceConfigurationForCreateInstanceInOneStepInput) SetConfigurationCode(v string) *InstanceConfigurationForCreateInstanceInOneStepInput {
	s.ConfigurationCode = &v
	return s
}

// SetDeletionProtection sets the DeletionProtection field's value.
func (s *InstanceConfigurationForCreateInstanceInOneStepInput) SetDeletionProtection(v bool) *InstanceConfigurationForCreateInstanceInOneStepInput {
	s.DeletionProtection = &v
	return s
}

// SetEnableCerebro sets the EnableCerebro field's value.
func (s *InstanceConfigurationForCreateInstanceInOneStepInput) SetEnableCerebro(v bool) *InstanceConfigurationForCreateInstanceInOneStepInput {
	s.EnableCerebro = &v
	return s
}

// SetEnableHttps sets the EnableHttps field's value.
func (s *InstanceConfigurationForCreateInstanceInOneStepInput) SetEnableHttps(v bool) *InstanceConfigurationForCreateInstanceInOneStepInput {
	s.EnableHttps = &v
	return s
}

// SetEnablePureMaster sets the EnablePureMaster field's value.
func (s *InstanceConfigurationForCreateInstanceInOneStepInput) SetEnablePureMaster(v bool) *InstanceConfigurationForCreateInstanceInOneStepInput {
	s.EnablePureMaster = &v
	return s
}

// SetInstanceName sets the InstanceName field's value.
func (s *InstanceConfigurationForCreateInstanceInOneStepInput) SetInstanceName(v string) *InstanceConfigurationForCreateInstanceInOneStepInput {
	s.InstanceName = &v
	return s
}

// SetNetworkSpecs sets the NetworkSpecs field's value.
func (s *InstanceConfigurationForCreateInstanceInOneStepInput) SetNetworkSpecs(v []*NetworkSpecForCreateInstanceInOneStepInput) *InstanceConfigurationForCreateInstanceInOneStepInput {
	s.NetworkSpecs = v
	return s
}

// SetNodeSpecsAssigns sets the NodeSpecsAssigns field's value.
func (s *InstanceConfigurationForCreateInstanceInOneStepInput) SetNodeSpecsAssigns(v []*NodeSpecsAssignForCreateInstanceInOneStepInput) *InstanceConfigurationForCreateInstanceInOneStepInput {
	s.NodeSpecsAssigns = v
	return s
}

// SetPeriod sets the Period field's value.
func (s *InstanceConfigurationForCreateInstanceInOneStepInput) SetPeriod(v int32) *InstanceConfigurationForCreateInstanceInOneStepInput {
	s.Period = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *InstanceConfigurationForCreateInstanceInOneStepInput) SetProjectName(v string) *InstanceConfigurationForCreateInstanceInOneStepInput {
	s.ProjectName = &v
	return s
}

// SetRegionId sets the RegionId field's value.
func (s *InstanceConfigurationForCreateInstanceInOneStepInput) SetRegionId(v string) *InstanceConfigurationForCreateInstanceInOneStepInput {
	s.RegionId = &v
	return s
}

// SetSubnet sets the Subnet field's value.
func (s *InstanceConfigurationForCreateInstanceInOneStepInput) SetSubnet(v *SubnetForCreateInstanceInOneStepInput) *InstanceConfigurationForCreateInstanceInOneStepInput {
	s.Subnet = v
	return s
}

// SetVPC sets the VPC field's value.
func (s *InstanceConfigurationForCreateInstanceInOneStepInput) SetVPC(v *VPCForCreateInstanceInOneStepInput) *InstanceConfigurationForCreateInstanceInOneStepInput {
	s.VPC = v
	return s
}

// SetVersion sets the Version field's value.
func (s *InstanceConfigurationForCreateInstanceInOneStepInput) SetVersion(v string) *InstanceConfigurationForCreateInstanceInOneStepInput {
	s.Version = &v
	return s
}

// SetZoneId sets the ZoneId field's value.
func (s *InstanceConfigurationForCreateInstanceInOneStepInput) SetZoneId(v string) *InstanceConfigurationForCreateInstanceInOneStepInput {
	s.ZoneId = &v
	return s
}

type NetworkSpecForCreateInstanceInOneStepInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Bandwidth *int32 `type:"int32" json:",omitempty"`

	IsOpen *bool `type:"boolean" json:",omitempty"`

	SpecName *string `type:"string" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s NetworkSpecForCreateInstanceInOneStepInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s NetworkSpecForCreateInstanceInOneStepInput) GoString() string {
	return s.String()
}

// SetBandwidth sets the Bandwidth field's value.
func (s *NetworkSpecForCreateInstanceInOneStepInput) SetBandwidth(v int32) *NetworkSpecForCreateInstanceInOneStepInput {
	s.Bandwidth = &v
	return s
}

// SetIsOpen sets the IsOpen field's value.
func (s *NetworkSpecForCreateInstanceInOneStepInput) SetIsOpen(v bool) *NetworkSpecForCreateInstanceInOneStepInput {
	s.IsOpen = &v
	return s
}

// SetSpecName sets the SpecName field's value.
func (s *NetworkSpecForCreateInstanceInOneStepInput) SetSpecName(v string) *NetworkSpecForCreateInstanceInOneStepInput {
	s.SpecName = &v
	return s
}

// SetType sets the Type field's value.
func (s *NetworkSpecForCreateInstanceInOneStepInput) SetType(v string) *NetworkSpecForCreateInstanceInOneStepInput {
	s.Type = &v
	return s
}

type NodeSpecsAssignForCreateInstanceInOneStepInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ExtraPerformance *ExtraPerformanceForCreateInstanceInOneStepInput `type:"structure" json:",omitempty"`

	Number *int32 `type:"int32" json:",omitempty"`

	ResourceSpecName *string `type:"string" json:",omitempty"`

	StorageSize *int32 `type:"int32" json:",omitempty"`

	StorageSpecName *string `type:"string" json:",omitempty"`

	Type *string `type:"string" json:",omitempty" enum:"EnumOfTypeForCreateInstanceInOneStepInput"`
}

// String returns the string representation
func (s NodeSpecsAssignForCreateInstanceInOneStepInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s NodeSpecsAssignForCreateInstanceInOneStepInput) GoString() string {
	return s.String()
}

// SetExtraPerformance sets the ExtraPerformance field's value.
func (s *NodeSpecsAssignForCreateInstanceInOneStepInput) SetExtraPerformance(v *ExtraPerformanceForCreateInstanceInOneStepInput) *NodeSpecsAssignForCreateInstanceInOneStepInput {
	s.ExtraPerformance = v
	return s
}

// SetNumber sets the Number field's value.
func (s *NodeSpecsAssignForCreateInstanceInOneStepInput) SetNumber(v int32) *NodeSpecsAssignForCreateInstanceInOneStepInput {
	s.Number = &v
	return s
}

// SetResourceSpecName sets the ResourceSpecName field's value.
func (s *NodeSpecsAssignForCreateInstanceInOneStepInput) SetResourceSpecName(v string) *NodeSpecsAssignForCreateInstanceInOneStepInput {
	s.ResourceSpecName = &v
	return s
}

// SetStorageSize sets the StorageSize field's value.
func (s *NodeSpecsAssignForCreateInstanceInOneStepInput) SetStorageSize(v int32) *NodeSpecsAssignForCreateInstanceInOneStepInput {
	s.StorageSize = &v
	return s
}

// SetStorageSpecName sets the StorageSpecName field's value.
func (s *NodeSpecsAssignForCreateInstanceInOneStepInput) SetStorageSpecName(v string) *NodeSpecsAssignForCreateInstanceInOneStepInput {
	s.StorageSpecName = &v
	return s
}

// SetType sets the Type field's value.
func (s *NodeSpecsAssignForCreateInstanceInOneStepInput) SetType(v string) *NodeSpecsAssignForCreateInstanceInOneStepInput {
	s.Type = &v
	return s
}

type SubnetForCreateInstanceInOneStepInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	SubnetId *string `type:"string" json:",omitempty"`

	SubnetName *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s SubnetForCreateInstanceInOneStepInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SubnetForCreateInstanceInOneStepInput) GoString() string {
	return s.String()
}

// SetSubnetId sets the SubnetId field's value.
func (s *SubnetForCreateInstanceInOneStepInput) SetSubnetId(v string) *SubnetForCreateInstanceInOneStepInput {
	s.SubnetId = &v
	return s
}

// SetSubnetName sets the SubnetName field's value.
func (s *SubnetForCreateInstanceInOneStepInput) SetSubnetName(v string) *SubnetForCreateInstanceInOneStepInput {
	s.SubnetName = &v
	return s
}

type TagForCreateInstanceInOneStepInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `min:"1" max:"128" type:"string" json:",omitempty"`

	Value *string `max:"256" type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TagForCreateInstanceInOneStepInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForCreateInstanceInOneStepInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagForCreateInstanceInOneStepInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagForCreateInstanceInOneStepInput"}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Key != nil && len(*s.Key) > 128 {
		invalidParams.Add(request.NewErrParamMaxLen("Key", 128, *s.Key))
	}
	if s.Value != nil && len(*s.Value) > 256 {
		invalidParams.Add(request.NewErrParamMaxLen("Value", 256, *s.Value))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *TagForCreateInstanceInOneStepInput) SetKey(v string) *TagForCreateInstanceInOneStepInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagForCreateInstanceInOneStepInput) SetValue(v string) *TagForCreateInstanceInOneStepInput {
	s.Value = &v
	return s
}

type VPCForCreateInstanceInOneStepInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	VpcId *string `type:"string" json:",omitempty"`

	VpcName *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s VPCForCreateInstanceInOneStepInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s VPCForCreateInstanceInOneStepInput) GoString() string {
	return s.String()
}

// SetVpcId sets the VpcId field's value.
func (s *VPCForCreateInstanceInOneStepInput) SetVpcId(v string) *VPCForCreateInstanceInOneStepInput {
	s.VpcId = &v
	return s
}

// SetVpcName sets the VpcName field's value.
func (s *VPCForCreateInstanceInOneStepInput) SetVpcName(v string) *VPCForCreateInstanceInOneStepInput {
	s.VpcName = &v
	return s
}

const (
	// EnumOfChargeTypeForCreateInstanceInOneStepInputPrePaid is a EnumOfChargeTypeForCreateInstanceInOneStepInput enum value
	EnumOfChargeTypeForCreateInstanceInOneStepInputPrePaid = "PrePaid"

	// EnumOfChargeTypeForCreateInstanceInOneStepInputPostPaid is a EnumOfChargeTypeForCreateInstanceInOneStepInput enum value
	EnumOfChargeTypeForCreateInstanceInOneStepInputPostPaid = "PostPaid"
)

const (
	// EnumOfTypeForCreateInstanceInOneStepInputMaster is a EnumOfTypeForCreateInstanceInOneStepInput enum value
	EnumOfTypeForCreateInstanceInOneStepInputMaster = "Master"

	// EnumOfTypeForCreateInstanceInOneStepInputKibana is a EnumOfTypeForCreateInstanceInOneStepInput enum value
	EnumOfTypeForCreateInstanceInOneStepInputKibana = "Kibana"

	// EnumOfTypeForCreateInstanceInOneStepInputHot is a EnumOfTypeForCreateInstanceInOneStepInput enum value
	EnumOfTypeForCreateInstanceInOneStepInputHot = "Hot"

	// EnumOfTypeForCreateInstanceInOneStepInputWarm is a EnumOfTypeForCreateInstanceInOneStepInput enum value
	EnumOfTypeForCreateInstanceInOneStepInputWarm = "Warm"

	// EnumOfTypeForCreateInstanceInOneStepInputCold is a EnumOfTypeForCreateInstanceInOneStepInput enum value
	EnumOfTypeForCreateInstanceInOneStepInputCold = "Cold"

	// EnumOfTypeForCreateInstanceInOneStepInputCoordinator is a EnumOfTypeForCreateInstanceInOneStepInput enum value
	EnumOfTypeForCreateInstanceInOneStepInputCoordinator = "Coordinator"

	// EnumOfTypeForCreateInstanceInOneStepInputOther is a EnumOfTypeForCreateInstanceInOneStepInput enum value
	EnumOfTypeForCreateInstanceInOneStepInputOther = "Other"
)

const (
	// EnumOfVersionForCreateInstanceInOneStepInputV67 is a EnumOfVersionForCreateInstanceInOneStepInput enum value
	EnumOfVersionForCreateInstanceInOneStepInputV67 = "V6_7"

	// EnumOfVersionForCreateInstanceInOneStepInputV710 is a EnumOfVersionForCreateInstanceInOneStepInput enum value
	EnumOfVersionForCreateInstanceInOneStepInputV710 = "V7_10"

	// EnumOfVersionForCreateInstanceInOneStepInputV7Tls is a EnumOfVersionForCreateInstanceInOneStepInput enum value
	EnumOfVersionForCreateInstanceInOneStepInputV7Tls = "V7_TLS"

	// EnumOfVersionForCreateInstanceInOneStepInputV7Byte is a EnumOfVersionForCreateInstanceInOneStepInput enum value
	EnumOfVersionForCreateInstanceInOneStepInputV7Byte = "V7_BYTE"

	// EnumOfVersionForCreateInstanceInOneStepInputOpenSearch29 is a EnumOfVersionForCreateInstanceInOneStepInput enum value
	EnumOfVersionForCreateInstanceInOneStepInputOpenSearch29 = "OPEN_SEARCH_2_9"
)
