// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package dcdn

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opUpdateSingleDomainConfigCommon = "UpdateSingleDomainConfig"

// UpdateSingleDomainConfigCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the UpdateSingleDomainConfigCommon operation. The "output" return
// value will be populated with the UpdateSingleDomainConfigCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned UpdateSingleDomainConfigCommon Request to send the API call to the service.
// the "output" return value is not valid until after UpdateSingleDomainConfigCommon Send returns without error.
//
// See UpdateSingleDomainConfigCommon for more information on using the UpdateSingleDomainConfigCommon
// API call, and error handling.
//
//    // Example sending a request using the UpdateSingleDomainConfigCommonRequest method.
//    req, resp := client.UpdateSingleDomainConfigCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *DCDN) UpdateSingleDomainConfigCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opUpdateSingleDomainConfigCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// UpdateSingleDomainConfigCommon API operation for DCDN.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for DCDN's
// API operation UpdateSingleDomainConfigCommon for usage and error information.
func (c *DCDN) UpdateSingleDomainConfigCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.UpdateSingleDomainConfigCommonRequest(input)
	return out, req.Send()
}

// UpdateSingleDomainConfigCommonWithContext is the same as UpdateSingleDomainConfigCommon with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSingleDomainConfigCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DCDN) UpdateSingleDomainConfigCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.UpdateSingleDomainConfigCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSingleDomainConfig = "UpdateSingleDomainConfig"

// UpdateSingleDomainConfigRequest generates a "volcengine/request.Request" representing the
// client's request for the UpdateSingleDomainConfig operation. The "output" return
// value will be populated with the UpdateSingleDomainConfigCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned UpdateSingleDomainConfigCommon Request to send the API call to the service.
// the "output" return value is not valid until after UpdateSingleDomainConfigCommon Send returns without error.
//
// See UpdateSingleDomainConfig for more information on using the UpdateSingleDomainConfig
// API call, and error handling.
//
//    // Example sending a request using the UpdateSingleDomainConfigRequest method.
//    req, resp := client.UpdateSingleDomainConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *DCDN) UpdateSingleDomainConfigRequest(input *UpdateSingleDomainConfigInput) (req *request.Request, output *UpdateSingleDomainConfigOutput) {
	op := &request.Operation{
		Name:       opUpdateSingleDomainConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateSingleDomainConfigInput{}
	}

	output = &UpdateSingleDomainConfigOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// UpdateSingleDomainConfig API operation for DCDN.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for DCDN's
// API operation UpdateSingleDomainConfig for usage and error information.
func (c *DCDN) UpdateSingleDomainConfig(input *UpdateSingleDomainConfigInput) (*UpdateSingleDomainConfigOutput, error) {
	req, out := c.UpdateSingleDomainConfigRequest(input)
	return out, req.Send()
}

// UpdateSingleDomainConfigWithContext is the same as UpdateSingleDomainConfig with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSingleDomainConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DCDN) UpdateSingleDomainConfigWithContext(ctx volcengine.Context, input *UpdateSingleDomainConfigInput, opts ...request.Option) (*UpdateSingleDomainConfigOutput, error) {
	req, out := c.UpdateSingleDomainConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type BackupOriginForUpdateSingleDomainConfigInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	Port *int32 `type:"int32" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`

	Weight *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s BackupOriginForUpdateSingleDomainConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s BackupOriginForUpdateSingleDomainConfigInput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *BackupOriginForUpdateSingleDomainConfigInput) SetName(v string) *BackupOriginForUpdateSingleDomainConfigInput {
	s.Name = &v
	return s
}

// SetPort sets the Port field's value.
func (s *BackupOriginForUpdateSingleDomainConfigInput) SetPort(v int32) *BackupOriginForUpdateSingleDomainConfigInput {
	s.Port = &v
	return s
}

// SetType sets the Type field's value.
func (s *BackupOriginForUpdateSingleDomainConfigInput) SetType(v string) *BackupOriginForUpdateSingleDomainConfigInput {
	s.Type = &v
	return s
}

// SetWeight sets the Weight field's value.
func (s *BackupOriginForUpdateSingleDomainConfigInput) SetWeight(v int32) *BackupOriginForUpdateSingleDomainConfigInput {
	s.Weight = &v
	return s
}

type BrCompressForUpdateSingleDomainConfigInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s BrCompressForUpdateSingleDomainConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s BrCompressForUpdateSingleDomainConfigInput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *BrCompressForUpdateSingleDomainConfigInput) SetEnable(v bool) *BrCompressForUpdateSingleDomainConfigInput {
	s.Enable = &v
	return s
}

type CacheForUpdateSingleDomainConfigInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AdaptCache *bool `type:"boolean" json:",omitempty"`

	CacheKeyRules []*CacheKeyRuleForUpdateSingleDomainConfigInput `type:"list" json:",omitempty"`

	CacheRules []*CacheRuleForUpdateSingleDomainConfigInput `type:"list" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`

	StatusCodeCacheRule *StatusCodeCacheRuleForUpdateSingleDomainConfigInput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s CacheForUpdateSingleDomainConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheForUpdateSingleDomainConfigInput) GoString() string {
	return s.String()
}

// SetAdaptCache sets the AdaptCache field's value.
func (s *CacheForUpdateSingleDomainConfigInput) SetAdaptCache(v bool) *CacheForUpdateSingleDomainConfigInput {
	s.AdaptCache = &v
	return s
}

// SetCacheKeyRules sets the CacheKeyRules field's value.
func (s *CacheForUpdateSingleDomainConfigInput) SetCacheKeyRules(v []*CacheKeyRuleForUpdateSingleDomainConfigInput) *CacheForUpdateSingleDomainConfigInput {
	s.CacheKeyRules = v
	return s
}

// SetCacheRules sets the CacheRules field's value.
func (s *CacheForUpdateSingleDomainConfigInput) SetCacheRules(v []*CacheRuleForUpdateSingleDomainConfigInput) *CacheForUpdateSingleDomainConfigInput {
	s.CacheRules = v
	return s
}

// SetEnable sets the Enable field's value.
func (s *CacheForUpdateSingleDomainConfigInput) SetEnable(v bool) *CacheForUpdateSingleDomainConfigInput {
	s.Enable = &v
	return s
}

// SetStatusCodeCacheRule sets the StatusCodeCacheRule field's value.
func (s *CacheForUpdateSingleDomainConfigInput) SetStatusCodeCacheRule(v *StatusCodeCacheRuleForUpdateSingleDomainConfigInput) *CacheForUpdateSingleDomainConfigInput {
	s.StatusCodeCacheRule = v
	return s
}

type CacheKeyRuleForUpdateSingleDomainConfigInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Contents *string `type:"string" json:",omitempty"`

	IgnoreCase *bool `type:"boolean" json:",omitempty"`

	ParamsFilterType *string `type:"string" json:",omitempty"`

	ParamsReserveList *string `type:"string" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CacheKeyRuleForUpdateSingleDomainConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheKeyRuleForUpdateSingleDomainConfigInput) GoString() string {
	return s.String()
}

// SetContents sets the Contents field's value.
func (s *CacheKeyRuleForUpdateSingleDomainConfigInput) SetContents(v string) *CacheKeyRuleForUpdateSingleDomainConfigInput {
	s.Contents = &v
	return s
}

// SetIgnoreCase sets the IgnoreCase field's value.
func (s *CacheKeyRuleForUpdateSingleDomainConfigInput) SetIgnoreCase(v bool) *CacheKeyRuleForUpdateSingleDomainConfigInput {
	s.IgnoreCase = &v
	return s
}

// SetParamsFilterType sets the ParamsFilterType field's value.
func (s *CacheKeyRuleForUpdateSingleDomainConfigInput) SetParamsFilterType(v string) *CacheKeyRuleForUpdateSingleDomainConfigInput {
	s.ParamsFilterType = &v
	return s
}

// SetParamsReserveList sets the ParamsReserveList field's value.
func (s *CacheKeyRuleForUpdateSingleDomainConfigInput) SetParamsReserveList(v string) *CacheKeyRuleForUpdateSingleDomainConfigInput {
	s.ParamsReserveList = &v
	return s
}

// SetType sets the Type field's value.
func (s *CacheKeyRuleForUpdateSingleDomainConfigInput) SetType(v string) *CacheKeyRuleForUpdateSingleDomainConfigInput {
	s.Type = &v
	return s
}

type CacheRuleForUpdateSingleDomainConfigInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CacheTime *int32 `type:"int32" json:",omitempty"`

	CacheTimeUnit *string `type:"string" json:",omitempty"`

	Contents *string `type:"string" json:",omitempty"`

	IgnoreCase *bool `type:"boolean" json:",omitempty"`

	ParamsFilterType *string `type:"string" json:",omitempty"`

	ParamsReserveList *string `type:"string" json:",omitempty"`

	Policy *string `type:"string" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CacheRuleForUpdateSingleDomainConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheRuleForUpdateSingleDomainConfigInput) GoString() string {
	return s.String()
}

// SetCacheTime sets the CacheTime field's value.
func (s *CacheRuleForUpdateSingleDomainConfigInput) SetCacheTime(v int32) *CacheRuleForUpdateSingleDomainConfigInput {
	s.CacheTime = &v
	return s
}

// SetCacheTimeUnit sets the CacheTimeUnit field's value.
func (s *CacheRuleForUpdateSingleDomainConfigInput) SetCacheTimeUnit(v string) *CacheRuleForUpdateSingleDomainConfigInput {
	s.CacheTimeUnit = &v
	return s
}

// SetContents sets the Contents field's value.
func (s *CacheRuleForUpdateSingleDomainConfigInput) SetContents(v string) *CacheRuleForUpdateSingleDomainConfigInput {
	s.Contents = &v
	return s
}

// SetIgnoreCase sets the IgnoreCase field's value.
func (s *CacheRuleForUpdateSingleDomainConfigInput) SetIgnoreCase(v bool) *CacheRuleForUpdateSingleDomainConfigInput {
	s.IgnoreCase = &v
	return s
}

// SetParamsFilterType sets the ParamsFilterType field's value.
func (s *CacheRuleForUpdateSingleDomainConfigInput) SetParamsFilterType(v string) *CacheRuleForUpdateSingleDomainConfigInput {
	s.ParamsFilterType = &v
	return s
}

// SetParamsReserveList sets the ParamsReserveList field's value.
func (s *CacheRuleForUpdateSingleDomainConfigInput) SetParamsReserveList(v string) *CacheRuleForUpdateSingleDomainConfigInput {
	s.ParamsReserveList = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *CacheRuleForUpdateSingleDomainConfigInput) SetPolicy(v string) *CacheRuleForUpdateSingleDomainConfigInput {
	s.Policy = &v
	return s
}

// SetType sets the Type field's value.
func (s *CacheRuleForUpdateSingleDomainConfigInput) SetType(v string) *CacheRuleForUpdateSingleDomainConfigInput {
	s.Type = &v
	return s
}

type CertBindForUpdateSingleDomainConfigInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CertId *string `type:"string" json:",omitempty"`

	CertSource *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CertBindForUpdateSingleDomainConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CertBindForUpdateSingleDomainConfigInput) GoString() string {
	return s.String()
}

// SetCertId sets the CertId field's value.
func (s *CertBindForUpdateSingleDomainConfigInput) SetCertId(v string) *CertBindForUpdateSingleDomainConfigInput {
	s.CertId = &v
	return s
}

// SetCertSource sets the CertSource field's value.
func (s *CertBindForUpdateSingleDomainConfigInput) SetCertSource(v string) *CertBindForUpdateSingleDomainConfigInput {
	s.CertSource = &v
	return s
}

type ConditionalOriginForUpdateSingleDomainConfigInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	BackupOrigins []*BackupOriginForUpdateSingleDomainConfigInput `type:"list" json:",omitempty"`

	MatchingRuleGroupJSON *string `type:"string" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	Origins []*BackupOriginForUpdateSingleDomainConfigInput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s ConditionalOriginForUpdateSingleDomainConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConditionalOriginForUpdateSingleDomainConfigInput) GoString() string {
	return s.String()
}

// SetBackupOrigins sets the BackupOrigins field's value.
func (s *ConditionalOriginForUpdateSingleDomainConfigInput) SetBackupOrigins(v []*BackupOriginForUpdateSingleDomainConfigInput) *ConditionalOriginForUpdateSingleDomainConfigInput {
	s.BackupOrigins = v
	return s
}

// SetMatchingRuleGroupJSON sets the MatchingRuleGroupJSON field's value.
func (s *ConditionalOriginForUpdateSingleDomainConfigInput) SetMatchingRuleGroupJSON(v string) *ConditionalOriginForUpdateSingleDomainConfigInput {
	s.MatchingRuleGroupJSON = &v
	return s
}

// SetName sets the Name field's value.
func (s *ConditionalOriginForUpdateSingleDomainConfigInput) SetName(v string) *ConditionalOriginForUpdateSingleDomainConfigInput {
	s.Name = &v
	return s
}

// SetOrigins sets the Origins field's value.
func (s *ConditionalOriginForUpdateSingleDomainConfigInput) SetOrigins(v []*BackupOriginForUpdateSingleDomainConfigInput) *ConditionalOriginForUpdateSingleDomainConfigInput {
	s.Origins = v
	return s
}

type ConvertConvertOriginForUpdateSingleDomainConfigInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	BackupOriginType *string `type:"string" json:",omitempty"`

	BackupOrigins []*BackupOriginForUpdateSingleDomainConfigInput `type:"list" json:",omitempty"`

	ConditionalOrigins []*ConditionalOriginForUpdateSingleDomainConfigInput `type:"list" json:",omitempty"`

	FollowRedirect *FollowRedirectForUpdateSingleDomainConfigInput `type:"structure" json:",omitempty"`

	OriginHost *OriginHostForUpdateSingleDomainConfigInput `type:"structure" json:",omitempty"`

	OriginProtocolType *string `type:"string" json:",omitempty"`

	OriginRange *OriginRangeForUpdateSingleDomainConfigInput `type:"structure" json:",omitempty"`

	OriginSni *OriginSniForUpdateSingleDomainConfigInput `type:"structure" json:",omitempty"`

	OriginType *string `type:"string" json:",omitempty"`

	Origins []*ConvertOriginForUpdateSingleDomainConfigInput `type:"list" json:",omitempty"`

	RequestHeader *RequestHeaderForUpdateSingleDomainConfigInput `type:"structure" json:",omitempty"`

	ResponseHeader *ResponseHeaderForUpdateSingleDomainConfigInput `type:"structure" json:",omitempty"`

	ResponseTimeout *int32 `type:"int32" json:",omitempty"`

	TosPrivateAccess *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s ConvertConvertOriginForUpdateSingleDomainConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConvertConvertOriginForUpdateSingleDomainConfigInput) GoString() string {
	return s.String()
}

// SetBackupOriginType sets the BackupOriginType field's value.
func (s *ConvertConvertOriginForUpdateSingleDomainConfigInput) SetBackupOriginType(v string) *ConvertConvertOriginForUpdateSingleDomainConfigInput {
	s.BackupOriginType = &v
	return s
}

// SetBackupOrigins sets the BackupOrigins field's value.
func (s *ConvertConvertOriginForUpdateSingleDomainConfigInput) SetBackupOrigins(v []*BackupOriginForUpdateSingleDomainConfigInput) *ConvertConvertOriginForUpdateSingleDomainConfigInput {
	s.BackupOrigins = v
	return s
}

// SetConditionalOrigins sets the ConditionalOrigins field's value.
func (s *ConvertConvertOriginForUpdateSingleDomainConfigInput) SetConditionalOrigins(v []*ConditionalOriginForUpdateSingleDomainConfigInput) *ConvertConvertOriginForUpdateSingleDomainConfigInput {
	s.ConditionalOrigins = v
	return s
}

// SetFollowRedirect sets the FollowRedirect field's value.
func (s *ConvertConvertOriginForUpdateSingleDomainConfigInput) SetFollowRedirect(v *FollowRedirectForUpdateSingleDomainConfigInput) *ConvertConvertOriginForUpdateSingleDomainConfigInput {
	s.FollowRedirect = v
	return s
}

// SetOriginHost sets the OriginHost field's value.
func (s *ConvertConvertOriginForUpdateSingleDomainConfigInput) SetOriginHost(v *OriginHostForUpdateSingleDomainConfigInput) *ConvertConvertOriginForUpdateSingleDomainConfigInput {
	s.OriginHost = v
	return s
}

// SetOriginProtocolType sets the OriginProtocolType field's value.
func (s *ConvertConvertOriginForUpdateSingleDomainConfigInput) SetOriginProtocolType(v string) *ConvertConvertOriginForUpdateSingleDomainConfigInput {
	s.OriginProtocolType = &v
	return s
}

// SetOriginRange sets the OriginRange field's value.
func (s *ConvertConvertOriginForUpdateSingleDomainConfigInput) SetOriginRange(v *OriginRangeForUpdateSingleDomainConfigInput) *ConvertConvertOriginForUpdateSingleDomainConfigInput {
	s.OriginRange = v
	return s
}

// SetOriginSni sets the OriginSni field's value.
func (s *ConvertConvertOriginForUpdateSingleDomainConfigInput) SetOriginSni(v *OriginSniForUpdateSingleDomainConfigInput) *ConvertConvertOriginForUpdateSingleDomainConfigInput {
	s.OriginSni = v
	return s
}

// SetOriginType sets the OriginType field's value.
func (s *ConvertConvertOriginForUpdateSingleDomainConfigInput) SetOriginType(v string) *ConvertConvertOriginForUpdateSingleDomainConfigInput {
	s.OriginType = &v
	return s
}

// SetOrigins sets the Origins field's value.
func (s *ConvertConvertOriginForUpdateSingleDomainConfigInput) SetOrigins(v []*ConvertOriginForUpdateSingleDomainConfigInput) *ConvertConvertOriginForUpdateSingleDomainConfigInput {
	s.Origins = v
	return s
}

// SetRequestHeader sets the RequestHeader field's value.
func (s *ConvertConvertOriginForUpdateSingleDomainConfigInput) SetRequestHeader(v *RequestHeaderForUpdateSingleDomainConfigInput) *ConvertConvertOriginForUpdateSingleDomainConfigInput {
	s.RequestHeader = v
	return s
}

// SetResponseHeader sets the ResponseHeader field's value.
func (s *ConvertConvertOriginForUpdateSingleDomainConfigInput) SetResponseHeader(v *ResponseHeaderForUpdateSingleDomainConfigInput) *ConvertConvertOriginForUpdateSingleDomainConfigInput {
	s.ResponseHeader = v
	return s
}

// SetResponseTimeout sets the ResponseTimeout field's value.
func (s *ConvertConvertOriginForUpdateSingleDomainConfigInput) SetResponseTimeout(v int32) *ConvertConvertOriginForUpdateSingleDomainConfigInput {
	s.ResponseTimeout = &v
	return s
}

// SetTosPrivateAccess sets the TosPrivateAccess field's value.
func (s *ConvertConvertOriginForUpdateSingleDomainConfigInput) SetTosPrivateAccess(v bool) *ConvertConvertOriginForUpdateSingleDomainConfigInput {
	s.TosPrivateAccess = &v
	return s
}

type ConvertOriginForUpdateSingleDomainConfigInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	Port *int32 `type:"int32" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`

	Weight *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s ConvertOriginForUpdateSingleDomainConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConvertOriginForUpdateSingleDomainConfigInput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *ConvertOriginForUpdateSingleDomainConfigInput) SetName(v string) *ConvertOriginForUpdateSingleDomainConfigInput {
	s.Name = &v
	return s
}

// SetPort sets the Port field's value.
func (s *ConvertOriginForUpdateSingleDomainConfigInput) SetPort(v int32) *ConvertOriginForUpdateSingleDomainConfigInput {
	s.Port = &v
	return s
}

// SetType sets the Type field's value.
func (s *ConvertOriginForUpdateSingleDomainConfigInput) SetType(v string) *ConvertOriginForUpdateSingleDomainConfigInput {
	s.Type = &v
	return s
}

// SetWeight sets the Weight field's value.
func (s *ConvertOriginForUpdateSingleDomainConfigInput) SetWeight(v int32) *ConvertOriginForUpdateSingleDomainConfigInput {
	s.Weight = &v
	return s
}

type ConvertRuleForUpdateSingleDomainConfigInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Match *string `type:"string" json:",omitempty"`

	Replacement *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ConvertRuleForUpdateSingleDomainConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConvertRuleForUpdateSingleDomainConfigInput) GoString() string {
	return s.String()
}

// SetMatch sets the Match field's value.
func (s *ConvertRuleForUpdateSingleDomainConfigInput) SetMatch(v string) *ConvertRuleForUpdateSingleDomainConfigInput {
	s.Match = &v
	return s
}

// SetReplacement sets the Replacement field's value.
func (s *ConvertRuleForUpdateSingleDomainConfigInput) SetReplacement(v string) *ConvertRuleForUpdateSingleDomainConfigInput {
	s.Replacement = &v
	return s
}

type FollowRedirectForUpdateSingleDomainConfigInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`

	MaxTries *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s FollowRedirectForUpdateSingleDomainConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s FollowRedirectForUpdateSingleDomainConfigInput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *FollowRedirectForUpdateSingleDomainConfigInput) SetEnable(v bool) *FollowRedirectForUpdateSingleDomainConfigInput {
	s.Enable = &v
	return s
}

// SetMaxTries sets the MaxTries field's value.
func (s *FollowRedirectForUpdateSingleDomainConfigInput) SetMaxTries(v int32) *FollowRedirectForUpdateSingleDomainConfigInput {
	s.MaxTries = &v
	return s
}

type ForceRedirectForUpdateSingleDomainConfigInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`

	RedirectType *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ForceRedirectForUpdateSingleDomainConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ForceRedirectForUpdateSingleDomainConfigInput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *ForceRedirectForUpdateSingleDomainConfigInput) SetEnable(v bool) *ForceRedirectForUpdateSingleDomainConfigInput {
	s.Enable = &v
	return s
}

// SetRedirectType sets the RedirectType field's value.
func (s *ForceRedirectForUpdateSingleDomainConfigInput) SetRedirectType(v string) *ForceRedirectForUpdateSingleDomainConfigInput {
	s.RedirectType = &v
	return s
}

type GzipCompressForUpdateSingleDomainConfigInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s GzipCompressForUpdateSingleDomainConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s GzipCompressForUpdateSingleDomainConfigInput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *GzipCompressForUpdateSingleDomainConfigInput) SetEnable(v bool) *GzipCompressForUpdateSingleDomainConfigInput {
	s.Enable = &v
	return s
}

type HeaderInfoForUpdateSingleDomainConfigInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	HeaderMode *int32 `type:"int32" json:",omitempty"`

	HeaderName *string `type:"string" json:",omitempty"`

	HeaderValue *string `type:"string" json:",omitempty"`

	HeaderValueType *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s HeaderInfoForUpdateSingleDomainConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s HeaderInfoForUpdateSingleDomainConfigInput) GoString() string {
	return s.String()
}

// SetHeaderMode sets the HeaderMode field's value.
func (s *HeaderInfoForUpdateSingleDomainConfigInput) SetHeaderMode(v int32) *HeaderInfoForUpdateSingleDomainConfigInput {
	s.HeaderMode = &v
	return s
}

// SetHeaderName sets the HeaderName field's value.
func (s *HeaderInfoForUpdateSingleDomainConfigInput) SetHeaderName(v string) *HeaderInfoForUpdateSingleDomainConfigInput {
	s.HeaderName = &v
	return s
}

// SetHeaderValue sets the HeaderValue field's value.
func (s *HeaderInfoForUpdateSingleDomainConfigInput) SetHeaderValue(v string) *HeaderInfoForUpdateSingleDomainConfigInput {
	s.HeaderValue = &v
	return s
}

// SetHeaderValueType sets the HeaderValueType field's value.
func (s *HeaderInfoForUpdateSingleDomainConfigInput) SetHeaderValueType(v string) *HeaderInfoForUpdateSingleDomainConfigInput {
	s.HeaderValueType = &v
	return s
}

type HstsForUpdateSingleDomainConfigInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`

	IncludeSubDomain *bool `type:"boolean" json:",omitempty"`

	MaxAge *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s HstsForUpdateSingleDomainConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s HstsForUpdateSingleDomainConfigInput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *HstsForUpdateSingleDomainConfigInput) SetEnable(v bool) *HstsForUpdateSingleDomainConfigInput {
	s.Enable = &v
	return s
}

// SetIncludeSubDomain sets the IncludeSubDomain field's value.
func (s *HstsForUpdateSingleDomainConfigInput) SetIncludeSubDomain(v bool) *HstsForUpdateSingleDomainConfigInput {
	s.IncludeSubDomain = &v
	return s
}

// SetMaxAge sets the MaxAge field's value.
func (s *HstsForUpdateSingleDomainConfigInput) SetMaxAge(v int32) *HstsForUpdateSingleDomainConfigInput {
	s.MaxAge = &v
	return s
}

type HttpsForUpdateSingleDomainConfigInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CertBind *CertBindForUpdateSingleDomainConfigInput `type:"structure" json:",omitempty"`

	ForceRedirect *ForceRedirectForUpdateSingleDomainConfigInput `type:"structure" json:",omitempty"`

	Hsts *HstsForUpdateSingleDomainConfigInput `type:"structure" json:",omitempty"`

	Http2 *bool `type:"boolean" json:",omitempty"`

	QUICSwitch *bool `type:"boolean" json:",omitempty"`

	TlsVersions *TlsVersionsForUpdateSingleDomainConfigInput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s HttpsForUpdateSingleDomainConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s HttpsForUpdateSingleDomainConfigInput) GoString() string {
	return s.String()
}

// SetCertBind sets the CertBind field's value.
func (s *HttpsForUpdateSingleDomainConfigInput) SetCertBind(v *CertBindForUpdateSingleDomainConfigInput) *HttpsForUpdateSingleDomainConfigInput {
	s.CertBind = v
	return s
}

// SetForceRedirect sets the ForceRedirect field's value.
func (s *HttpsForUpdateSingleDomainConfigInput) SetForceRedirect(v *ForceRedirectForUpdateSingleDomainConfigInput) *HttpsForUpdateSingleDomainConfigInput {
	s.ForceRedirect = v
	return s
}

// SetHsts sets the Hsts field's value.
func (s *HttpsForUpdateSingleDomainConfigInput) SetHsts(v *HstsForUpdateSingleDomainConfigInput) *HttpsForUpdateSingleDomainConfigInput {
	s.Hsts = v
	return s
}

// SetHttp2 sets the Http2 field's value.
func (s *HttpsForUpdateSingleDomainConfigInput) SetHttp2(v bool) *HttpsForUpdateSingleDomainConfigInput {
	s.Http2 = &v
	return s
}

// SetQUICSwitch sets the QUICSwitch field's value.
func (s *HttpsForUpdateSingleDomainConfigInput) SetQUICSwitch(v bool) *HttpsForUpdateSingleDomainConfigInput {
	s.QUICSwitch = &v
	return s
}

// SetTlsVersions sets the TlsVersions field's value.
func (s *HttpsForUpdateSingleDomainConfigInput) SetTlsVersions(v *TlsVersionsForUpdateSingleDomainConfigInput) *HttpsForUpdateSingleDomainConfigInput {
	s.TlsVersions = v
	return s
}

type IpAccessForUpdateSingleDomainConfigInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`

	FilterList []*string `type:"list" json:",omitempty"`

	FilterType *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s IpAccessForUpdateSingleDomainConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s IpAccessForUpdateSingleDomainConfigInput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *IpAccessForUpdateSingleDomainConfigInput) SetEnable(v bool) *IpAccessForUpdateSingleDomainConfigInput {
	s.Enable = &v
	return s
}

// SetFilterList sets the FilterList field's value.
func (s *IpAccessForUpdateSingleDomainConfigInput) SetFilterList(v []*string) *IpAccessForUpdateSingleDomainConfigInput {
	s.FilterList = v
	return s
}

// SetFilterType sets the FilterType field's value.
func (s *IpAccessForUpdateSingleDomainConfigInput) SetFilterType(v string) *IpAccessForUpdateSingleDomainConfigInput {
	s.FilterType = &v
	return s
}

type OriginHostForUpdateSingleDomainConfigInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`

	HostInfo *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s OriginHostForUpdateSingleDomainConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginHostForUpdateSingleDomainConfigInput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *OriginHostForUpdateSingleDomainConfigInput) SetEnable(v bool) *OriginHostForUpdateSingleDomainConfigInput {
	s.Enable = &v
	return s
}

// SetHostInfo sets the HostInfo field's value.
func (s *OriginHostForUpdateSingleDomainConfigInput) SetHostInfo(v string) *OriginHostForUpdateSingleDomainConfigInput {
	s.HostInfo = &v
	return s
}

type OriginRangeForUpdateSingleDomainConfigInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s OriginRangeForUpdateSingleDomainConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginRangeForUpdateSingleDomainConfigInput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *OriginRangeForUpdateSingleDomainConfigInput) SetEnable(v bool) *OriginRangeForUpdateSingleDomainConfigInput {
	s.Enable = &v
	return s
}

type OriginSniForUpdateSingleDomainConfigInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`

	SniInfo *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s OriginSniForUpdateSingleDomainConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginSniForUpdateSingleDomainConfigInput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *OriginSniForUpdateSingleDomainConfigInput) SetEnable(v bool) *OriginSniForUpdateSingleDomainConfigInput {
	s.Enable = &v
	return s
}

// SetSniInfo sets the SniInfo field's value.
func (s *OriginSniForUpdateSingleDomainConfigInput) SetSniInfo(v string) *OriginSniForUpdateSingleDomainConfigInput {
	s.SniInfo = &v
	return s
}

type PreConnectForUpdateSingleDomainConfigInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s PreConnectForUpdateSingleDomainConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s PreConnectForUpdateSingleDomainConfigInput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *PreConnectForUpdateSingleDomainConfigInput) SetEnable(v bool) *PreConnectForUpdateSingleDomainConfigInput {
	s.Enable = &v
	return s
}

type RTTOptimizeForUpdateSingleDomainConfigInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s RTTOptimizeForUpdateSingleDomainConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RTTOptimizeForUpdateSingleDomainConfigInput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *RTTOptimizeForUpdateSingleDomainConfigInput) SetEnable(v bool) *RTTOptimizeForUpdateSingleDomainConfigInput {
	s.Enable = &v
	return s
}

type RefererAccessForUpdateSingleDomainConfigInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AllowNone *bool `type:"boolean" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`

	FilterList []*string `type:"list" json:",omitempty"`

	FilterType *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s RefererAccessForUpdateSingleDomainConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RefererAccessForUpdateSingleDomainConfigInput) GoString() string {
	return s.String()
}

// SetAllowNone sets the AllowNone field's value.
func (s *RefererAccessForUpdateSingleDomainConfigInput) SetAllowNone(v bool) *RefererAccessForUpdateSingleDomainConfigInput {
	s.AllowNone = &v
	return s
}

// SetEnable sets the Enable field's value.
func (s *RefererAccessForUpdateSingleDomainConfigInput) SetEnable(v bool) *RefererAccessForUpdateSingleDomainConfigInput {
	s.Enable = &v
	return s
}

// SetFilterList sets the FilterList field's value.
func (s *RefererAccessForUpdateSingleDomainConfigInput) SetFilterList(v []*string) *RefererAccessForUpdateSingleDomainConfigInput {
	s.FilterList = v
	return s
}

// SetFilterType sets the FilterType field's value.
func (s *RefererAccessForUpdateSingleDomainConfigInput) SetFilterType(v string) *RefererAccessForUpdateSingleDomainConfigInput {
	s.FilterType = &v
	return s
}

type RequestHeaderForUpdateSingleDomainConfigInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`

	HeaderInfo []*HeaderInfoForUpdateSingleDomainConfigInput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s RequestHeaderForUpdateSingleDomainConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestHeaderForUpdateSingleDomainConfigInput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *RequestHeaderForUpdateSingleDomainConfigInput) SetEnable(v bool) *RequestHeaderForUpdateSingleDomainConfigInput {
	s.Enable = &v
	return s
}

// SetHeaderInfo sets the HeaderInfo field's value.
func (s *RequestHeaderForUpdateSingleDomainConfigInput) SetHeaderInfo(v []*HeaderInfoForUpdateSingleDomainConfigInput) *RequestHeaderForUpdateSingleDomainConfigInput {
	s.HeaderInfo = v
	return s
}

type ResponseHeaderForUpdateSingleDomainConfigInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`

	HeaderInfo []*HeaderInfoForUpdateSingleDomainConfigInput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s ResponseHeaderForUpdateSingleDomainConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ResponseHeaderForUpdateSingleDomainConfigInput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *ResponseHeaderForUpdateSingleDomainConfigInput) SetEnable(v bool) *ResponseHeaderForUpdateSingleDomainConfigInput {
	s.Enable = &v
	return s
}

// SetHeaderInfo sets the HeaderInfo field's value.
func (s *ResponseHeaderForUpdateSingleDomainConfigInput) SetHeaderInfo(v []*HeaderInfoForUpdateSingleDomainConfigInput) *ResponseHeaderForUpdateSingleDomainConfigInput {
	s.HeaderInfo = v
	return s
}

type RuleForUpdateSingleDomainConfigInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CacheTime *int32 `type:"int32" json:",omitempty"`

	CacheTimeUnit *string `type:"string" json:",omitempty"`

	RespUrl *string `type:"string" json:",omitempty"`

	Status *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s RuleForUpdateSingleDomainConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RuleForUpdateSingleDomainConfigInput) GoString() string {
	return s.String()
}

// SetCacheTime sets the CacheTime field's value.
func (s *RuleForUpdateSingleDomainConfigInput) SetCacheTime(v int32) *RuleForUpdateSingleDomainConfigInput {
	s.CacheTime = &v
	return s
}

// SetCacheTimeUnit sets the CacheTimeUnit field's value.
func (s *RuleForUpdateSingleDomainConfigInput) SetCacheTimeUnit(v string) *RuleForUpdateSingleDomainConfigInput {
	s.CacheTimeUnit = &v
	return s
}

// SetRespUrl sets the RespUrl field's value.
func (s *RuleForUpdateSingleDomainConfigInput) SetRespUrl(v string) *RuleForUpdateSingleDomainConfigInput {
	s.RespUrl = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *RuleForUpdateSingleDomainConfigInput) SetStatus(v string) *RuleForUpdateSingleDomainConfigInput {
	s.Status = &v
	return s
}

type StaticOptimizationForUpdateSingleDomainConfigInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	H2Priority *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s StaticOptimizationForUpdateSingleDomainConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StaticOptimizationForUpdateSingleDomainConfigInput) GoString() string {
	return s.String()
}

// SetH2Priority sets the H2Priority field's value.
func (s *StaticOptimizationForUpdateSingleDomainConfigInput) SetH2Priority(v bool) *StaticOptimizationForUpdateSingleDomainConfigInput {
	s.H2Priority = &v
	return s
}

type StatusCodeCacheRuleForUpdateSingleDomainConfigInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`

	Rules []*RuleForUpdateSingleDomainConfigInput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s StatusCodeCacheRuleForUpdateSingleDomainConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StatusCodeCacheRuleForUpdateSingleDomainConfigInput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *StatusCodeCacheRuleForUpdateSingleDomainConfigInput) SetEnable(v bool) *StatusCodeCacheRuleForUpdateSingleDomainConfigInput {
	s.Enable = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *StatusCodeCacheRuleForUpdateSingleDomainConfigInput) SetRules(v []*RuleForUpdateSingleDomainConfigInput) *StatusCodeCacheRuleForUpdateSingleDomainConfigInput {
	s.Rules = v
	return s
}

type TlsVersionsForUpdateSingleDomainConfigInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`

	TlsVersion []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s TlsVersionsForUpdateSingleDomainConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TlsVersionsForUpdateSingleDomainConfigInput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *TlsVersionsForUpdateSingleDomainConfigInput) SetEnable(v bool) *TlsVersionsForUpdateSingleDomainConfigInput {
	s.Enable = &v
	return s
}

// SetTlsVersion sets the TlsVersion field's value.
func (s *TlsVersionsForUpdateSingleDomainConfigInput) SetTlsVersion(v []*string) *TlsVersionsForUpdateSingleDomainConfigInput {
	s.TlsVersion = v
	return s
}

type UpdateSingleDomainConfigInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	BrCompress *BrCompressForUpdateSingleDomainConfigInput `type:"structure" json:",omitempty"`

	Cache *CacheForUpdateSingleDomainConfigInput `type:"structure" json:",omitempty"`

	// Domain is a required field
	Domain *string `type:"string" json:",omitempty" required:"true"`

	EnableFailOver *bool `type:"boolean" json:",omitempty"`

	GzipCompress *GzipCompressForUpdateSingleDomainConfigInput `type:"structure" json:",omitempty"`

	Https *HttpsForUpdateSingleDomainConfigInput `type:"structure" json:",omitempty"`

	IPv6Switch *bool `type:"boolean" json:",omitempty"`

	IpAccess *IpAccessForUpdateSingleDomainConfigInput `type:"structure" json:",omitempty"`

	Origin *ConvertConvertOriginForUpdateSingleDomainConfigInput `type:"structure" json:",omitempty"`

	PreConnect *PreConnectForUpdateSingleDomainConfigInput `type:"structure" json:",omitempty"`

	RTTOptimize *RTTOptimizeForUpdateSingleDomainConfigInput `type:"structure" json:",omitempty"`

	RefererAccess *RefererAccessForUpdateSingleDomainConfigInput `type:"structure" json:",omitempty"`

	Scope *string `type:"string" json:",omitempty"`

	ServiceType *string `type:"string" json:",omitempty"`

	StaticOptimization *StaticOptimizationForUpdateSingleDomainConfigInput `type:"structure" json:",omitempty"`

	StrategyType *string `type:"string" json:",omitempty"`

	UploadOptimize *UploadOptimizeForUpdateSingleDomainConfigInput `type:"structure" json:",omitempty"`

	UrlAccess *UrlAccessForUpdateSingleDomainConfigInput `type:"structure" json:",omitempty"`

	UrlRedirect *UrlRedirectForUpdateSingleDomainConfigInput `type:"structure" json:",omitempty"`

	UserAgentAccess *UserAgentAccessForUpdateSingleDomainConfigInput `type:"structure" json:",omitempty"`

	WebSocket *WebSocketForUpdateSingleDomainConfigInput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s UpdateSingleDomainConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSingleDomainConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSingleDomainConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSingleDomainConfigInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBrCompress sets the BrCompress field's value.
func (s *UpdateSingleDomainConfigInput) SetBrCompress(v *BrCompressForUpdateSingleDomainConfigInput) *UpdateSingleDomainConfigInput {
	s.BrCompress = v
	return s
}

// SetCache sets the Cache field's value.
func (s *UpdateSingleDomainConfigInput) SetCache(v *CacheForUpdateSingleDomainConfigInput) *UpdateSingleDomainConfigInput {
	s.Cache = v
	return s
}

// SetDomain sets the Domain field's value.
func (s *UpdateSingleDomainConfigInput) SetDomain(v string) *UpdateSingleDomainConfigInput {
	s.Domain = &v
	return s
}

// SetEnableFailOver sets the EnableFailOver field's value.
func (s *UpdateSingleDomainConfigInput) SetEnableFailOver(v bool) *UpdateSingleDomainConfigInput {
	s.EnableFailOver = &v
	return s
}

// SetGzipCompress sets the GzipCompress field's value.
func (s *UpdateSingleDomainConfigInput) SetGzipCompress(v *GzipCompressForUpdateSingleDomainConfigInput) *UpdateSingleDomainConfigInput {
	s.GzipCompress = v
	return s
}

// SetHttps sets the Https field's value.
func (s *UpdateSingleDomainConfigInput) SetHttps(v *HttpsForUpdateSingleDomainConfigInput) *UpdateSingleDomainConfigInput {
	s.Https = v
	return s
}

// SetIPv6Switch sets the IPv6Switch field's value.
func (s *UpdateSingleDomainConfigInput) SetIPv6Switch(v bool) *UpdateSingleDomainConfigInput {
	s.IPv6Switch = &v
	return s
}

// SetIpAccess sets the IpAccess field's value.
func (s *UpdateSingleDomainConfigInput) SetIpAccess(v *IpAccessForUpdateSingleDomainConfigInput) *UpdateSingleDomainConfigInput {
	s.IpAccess = v
	return s
}

// SetOrigin sets the Origin field's value.
func (s *UpdateSingleDomainConfigInput) SetOrigin(v *ConvertConvertOriginForUpdateSingleDomainConfigInput) *UpdateSingleDomainConfigInput {
	s.Origin = v
	return s
}

// SetPreConnect sets the PreConnect field's value.
func (s *UpdateSingleDomainConfigInput) SetPreConnect(v *PreConnectForUpdateSingleDomainConfigInput) *UpdateSingleDomainConfigInput {
	s.PreConnect = v
	return s
}

// SetRTTOptimize sets the RTTOptimize field's value.
func (s *UpdateSingleDomainConfigInput) SetRTTOptimize(v *RTTOptimizeForUpdateSingleDomainConfigInput) *UpdateSingleDomainConfigInput {
	s.RTTOptimize = v
	return s
}

// SetRefererAccess sets the RefererAccess field's value.
func (s *UpdateSingleDomainConfigInput) SetRefererAccess(v *RefererAccessForUpdateSingleDomainConfigInput) *UpdateSingleDomainConfigInput {
	s.RefererAccess = v
	return s
}

// SetScope sets the Scope field's value.
func (s *UpdateSingleDomainConfigInput) SetScope(v string) *UpdateSingleDomainConfigInput {
	s.Scope = &v
	return s
}

// SetServiceType sets the ServiceType field's value.
func (s *UpdateSingleDomainConfigInput) SetServiceType(v string) *UpdateSingleDomainConfigInput {
	s.ServiceType = &v
	return s
}

// SetStaticOptimization sets the StaticOptimization field's value.
func (s *UpdateSingleDomainConfigInput) SetStaticOptimization(v *StaticOptimizationForUpdateSingleDomainConfigInput) *UpdateSingleDomainConfigInput {
	s.StaticOptimization = v
	return s
}

// SetStrategyType sets the StrategyType field's value.
func (s *UpdateSingleDomainConfigInput) SetStrategyType(v string) *UpdateSingleDomainConfigInput {
	s.StrategyType = &v
	return s
}

// SetUploadOptimize sets the UploadOptimize field's value.
func (s *UpdateSingleDomainConfigInput) SetUploadOptimize(v *UploadOptimizeForUpdateSingleDomainConfigInput) *UpdateSingleDomainConfigInput {
	s.UploadOptimize = v
	return s
}

// SetUrlAccess sets the UrlAccess field's value.
func (s *UpdateSingleDomainConfigInput) SetUrlAccess(v *UrlAccessForUpdateSingleDomainConfigInput) *UpdateSingleDomainConfigInput {
	s.UrlAccess = v
	return s
}

// SetUrlRedirect sets the UrlRedirect field's value.
func (s *UpdateSingleDomainConfigInput) SetUrlRedirect(v *UrlRedirectForUpdateSingleDomainConfigInput) *UpdateSingleDomainConfigInput {
	s.UrlRedirect = v
	return s
}

// SetUserAgentAccess sets the UserAgentAccess field's value.
func (s *UpdateSingleDomainConfigInput) SetUserAgentAccess(v *UserAgentAccessForUpdateSingleDomainConfigInput) *UpdateSingleDomainConfigInput {
	s.UserAgentAccess = v
	return s
}

// SetWebSocket sets the WebSocket field's value.
func (s *UpdateSingleDomainConfigInput) SetWebSocket(v *WebSocketForUpdateSingleDomainConfigInput) *UpdateSingleDomainConfigInput {
	s.WebSocket = v
	return s
}

type UpdateSingleDomainConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata
}

// String returns the string representation
func (s UpdateSingleDomainConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSingleDomainConfigOutput) GoString() string {
	return s.String()
}

type UploadOptimizeForUpdateSingleDomainConfigInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s UploadOptimizeForUpdateSingleDomainConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UploadOptimizeForUpdateSingleDomainConfigInput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *UploadOptimizeForUpdateSingleDomainConfigInput) SetEnable(v bool) *UploadOptimizeForUpdateSingleDomainConfigInput {
	s.Enable = &v
	return s
}

type UrlAccessForUpdateSingleDomainConfigInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`

	GenKey *string `type:"string" json:",omitempty"`

	GenTTL *int32 `type:"int32" json:",omitempty"`

	GenType *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s UrlAccessForUpdateSingleDomainConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UrlAccessForUpdateSingleDomainConfigInput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *UrlAccessForUpdateSingleDomainConfigInput) SetEnable(v bool) *UrlAccessForUpdateSingleDomainConfigInput {
	s.Enable = &v
	return s
}

// SetGenKey sets the GenKey field's value.
func (s *UrlAccessForUpdateSingleDomainConfigInput) SetGenKey(v string) *UrlAccessForUpdateSingleDomainConfigInput {
	s.GenKey = &v
	return s
}

// SetGenTTL sets the GenTTL field's value.
func (s *UrlAccessForUpdateSingleDomainConfigInput) SetGenTTL(v int32) *UrlAccessForUpdateSingleDomainConfigInput {
	s.GenTTL = &v
	return s
}

// SetGenType sets the GenType field's value.
func (s *UrlAccessForUpdateSingleDomainConfigInput) SetGenType(v string) *UrlAccessForUpdateSingleDomainConfigInput {
	s.GenType = &v
	return s
}

type UrlRedirectForUpdateSingleDomainConfigInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`

	Rules []*ConvertRuleForUpdateSingleDomainConfigInput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s UrlRedirectForUpdateSingleDomainConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UrlRedirectForUpdateSingleDomainConfigInput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *UrlRedirectForUpdateSingleDomainConfigInput) SetEnable(v bool) *UrlRedirectForUpdateSingleDomainConfigInput {
	s.Enable = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *UrlRedirectForUpdateSingleDomainConfigInput) SetRules(v []*ConvertRuleForUpdateSingleDomainConfigInput) *UrlRedirectForUpdateSingleDomainConfigInput {
	s.Rules = v
	return s
}

type UserAgentAccessForUpdateSingleDomainConfigInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`

	FilterList []*string `type:"list" json:",omitempty"`

	FilterType *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s UserAgentAccessForUpdateSingleDomainConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UserAgentAccessForUpdateSingleDomainConfigInput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *UserAgentAccessForUpdateSingleDomainConfigInput) SetEnable(v bool) *UserAgentAccessForUpdateSingleDomainConfigInput {
	s.Enable = &v
	return s
}

// SetFilterList sets the FilterList field's value.
func (s *UserAgentAccessForUpdateSingleDomainConfigInput) SetFilterList(v []*string) *UserAgentAccessForUpdateSingleDomainConfigInput {
	s.FilterList = v
	return s
}

// SetFilterType sets the FilterType field's value.
func (s *UserAgentAccessForUpdateSingleDomainConfigInput) SetFilterType(v string) *UserAgentAccessForUpdateSingleDomainConfigInput {
	s.FilterType = &v
	return s
}

type WebSocketForUpdateSingleDomainConfigInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`

	Timeout *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s WebSocketForUpdateSingleDomainConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s WebSocketForUpdateSingleDomainConfigInput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *WebSocketForUpdateSingleDomainConfigInput) SetEnable(v bool) *WebSocketForUpdateSingleDomainConfigInput {
	s.Enable = &v
	return s
}

// SetTimeout sets the Timeout field's value.
func (s *WebSocketForUpdateSingleDomainConfigInput) SetTimeout(v int32) *WebSocketForUpdateSingleDomainConfigInput {
	s.Timeout = &v
	return s
}
