// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package cdn

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opDescribeContentBlockTasksCommon = "DescribeContentBlockTasks"

// DescribeContentBlockTasksCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeContentBlockTasksCommon operation. The "output" return
// value will be populated with the DescribeContentBlockTasksCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeContentBlockTasksCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeContentBlockTasksCommon Send returns without error.
//
// See DescribeContentBlockTasksCommon for more information on using the DescribeContentBlockTasksCommon
// API call, and error handling.
//
//    // Example sending a request using the DescribeContentBlockTasksCommonRequest method.
//    req, resp := client.DescribeContentBlockTasksCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CDN) DescribeContentBlockTasksCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opDescribeContentBlockTasksCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeContentBlockTasksCommon API operation for CDN.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CDN's
// API operation DescribeContentBlockTasksCommon for usage and error information.
func (c *CDN) DescribeContentBlockTasksCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.DescribeContentBlockTasksCommonRequest(input)
	return out, req.Send()
}

// DescribeContentBlockTasksCommonWithContext is the same as DescribeContentBlockTasksCommon with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeContentBlockTasksCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CDN) DescribeContentBlockTasksCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.DescribeContentBlockTasksCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeContentBlockTasks = "DescribeContentBlockTasks"

// DescribeContentBlockTasksRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeContentBlockTasks operation. The "output" return
// value will be populated with the DescribeContentBlockTasksCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeContentBlockTasksCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeContentBlockTasksCommon Send returns without error.
//
// See DescribeContentBlockTasks for more information on using the DescribeContentBlockTasks
// API call, and error handling.
//
//    // Example sending a request using the DescribeContentBlockTasksRequest method.
//    req, resp := client.DescribeContentBlockTasksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CDN) DescribeContentBlockTasksRequest(input *DescribeContentBlockTasksInput) (req *request.Request, output *DescribeContentBlockTasksOutput) {
	op := &request.Operation{
		Name:       opDescribeContentBlockTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeContentBlockTasksInput{}
	}

	output = &DescribeContentBlockTasksOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeContentBlockTasks API operation for CDN.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CDN's
// API operation DescribeContentBlockTasks for usage and error information.
func (c *CDN) DescribeContentBlockTasks(input *DescribeContentBlockTasksInput) (*DescribeContentBlockTasksOutput, error) {
	req, out := c.DescribeContentBlockTasksRequest(input)
	return out, req.Send()
}

// DescribeContentBlockTasksWithContext is the same as DescribeContentBlockTasks with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeContentBlockTasks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CDN) DescribeContentBlockTasksWithContext(ctx volcengine.Context, input *DescribeContentBlockTasksInput, opts ...request.Option) (*DescribeContentBlockTasksOutput, error) {
	req, out := c.DescribeContentBlockTasksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type DataForDescribeContentBlockTasksOutput struct {
	_ struct{} `type:"structure"`

	BlockReason *string `type:"string"`

	CreateTime *int64 `type:"int64"`

	Status *string `type:"string"`

	TaskID *string `type:"string"`

	TaskType *string `type:"string"`

	Url *string `type:"string"`
}

// String returns the string representation
func (s DataForDescribeContentBlockTasksOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DataForDescribeContentBlockTasksOutput) GoString() string {
	return s.String()
}

// SetBlockReason sets the BlockReason field's value.
func (s *DataForDescribeContentBlockTasksOutput) SetBlockReason(v string) *DataForDescribeContentBlockTasksOutput {
	s.BlockReason = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *DataForDescribeContentBlockTasksOutput) SetCreateTime(v int64) *DataForDescribeContentBlockTasksOutput {
	s.CreateTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DataForDescribeContentBlockTasksOutput) SetStatus(v string) *DataForDescribeContentBlockTasksOutput {
	s.Status = &v
	return s
}

// SetTaskID sets the TaskID field's value.
func (s *DataForDescribeContentBlockTasksOutput) SetTaskID(v string) *DataForDescribeContentBlockTasksOutput {
	s.TaskID = &v
	return s
}

// SetTaskType sets the TaskType field's value.
func (s *DataForDescribeContentBlockTasksOutput) SetTaskType(v string) *DataForDescribeContentBlockTasksOutput {
	s.TaskType = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *DataForDescribeContentBlockTasksOutput) SetUrl(v string) *DataForDescribeContentBlockTasksOutput {
	s.Url = &v
	return s
}

type DescribeContentBlockTasksInput struct {
	_ struct{} `type:"structure"`

	DomainName *string `type:"string"`

	EndTime *int64 `type:"int64"`

	PageNum *int32 `type:"int32"`

	PageSize *int32 `type:"int32"`

	StartTime *int64 `type:"int64"`

	Status *string `type:"string"`

	TaskID *string `type:"string"`

	// TaskType is a required field
	TaskType *string `type:"string" required:"true"`

	URL *string `type:"string"`
}

// String returns the string representation
func (s DescribeContentBlockTasksInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeContentBlockTasksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeContentBlockTasksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeContentBlockTasksInput"}
	if s.TaskType == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *DescribeContentBlockTasksInput) SetDomainName(v string) *DescribeContentBlockTasksInput {
	s.DomainName = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *DescribeContentBlockTasksInput) SetEndTime(v int64) *DescribeContentBlockTasksInput {
	s.EndTime = &v
	return s
}

// SetPageNum sets the PageNum field's value.
func (s *DescribeContentBlockTasksInput) SetPageNum(v int32) *DescribeContentBlockTasksInput {
	s.PageNum = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *DescribeContentBlockTasksInput) SetPageSize(v int32) *DescribeContentBlockTasksInput {
	s.PageSize = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *DescribeContentBlockTasksInput) SetStartTime(v int64) *DescribeContentBlockTasksInput {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeContentBlockTasksInput) SetStatus(v string) *DescribeContentBlockTasksInput {
	s.Status = &v
	return s
}

// SetTaskID sets the TaskID field's value.
func (s *DescribeContentBlockTasksInput) SetTaskID(v string) *DescribeContentBlockTasksInput {
	s.TaskID = &v
	return s
}

// SetTaskType sets the TaskType field's value.
func (s *DescribeContentBlockTasksInput) SetTaskType(v string) *DescribeContentBlockTasksInput {
	s.TaskType = &v
	return s
}

// SetURL sets the URL field's value.
func (s *DescribeContentBlockTasksInput) SetURL(v string) *DescribeContentBlockTasksInput {
	s.URL = &v
	return s
}

type DescribeContentBlockTasksOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	Data []*DataForDescribeContentBlockTasksOutput `type:"list"`

	PageNum *int64 `type:"int64"`

	PageSize *int64 `type:"int64"`

	Total *int64 `type:"int64"`
}

// String returns the string representation
func (s DescribeContentBlockTasksOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeContentBlockTasksOutput) GoString() string {
	return s.String()
}

// SetData sets the Data field's value.
func (s *DescribeContentBlockTasksOutput) SetData(v []*DataForDescribeContentBlockTasksOutput) *DescribeContentBlockTasksOutput {
	s.Data = v
	return s
}

// SetPageNum sets the PageNum field's value.
func (s *DescribeContentBlockTasksOutput) SetPageNum(v int64) *DescribeContentBlockTasksOutput {
	s.PageNum = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *DescribeContentBlockTasksOutput) SetPageSize(v int64) *DescribeContentBlockTasksOutput {
	s.PageSize = &v
	return s
}

// SetTotal sets the Total field's value.
func (s *DescribeContentBlockTasksOutput) SetTotal(v int64) *DescribeContentBlockTasksOutput {
	s.Total = &v
	return s
}
