// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package alb

import (
	"fmt"

	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateRulesCommon = "CreateRules"

// CreateRulesCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateRulesCommon operation. The "output" return
// value will be populated with the CreateRulesCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateRulesCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateRulesCommon Send returns without error.
//
// See CreateRulesCommon for more information on using the CreateRulesCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateRulesCommonRequest method.
//    req, resp := client.CreateRulesCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ALB) CreateRulesCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateRulesCommon,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	return
}

// CreateRulesCommon API operation for ALB.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ALB's
// API operation CreateRulesCommon for usage and error information.
func (c *ALB) CreateRulesCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateRulesCommonRequest(input)
	return out, req.Send()
}

// CreateRulesCommonWithContext is the same as CreateRulesCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRulesCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ALB) CreateRulesCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateRulesCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRules = "CreateRules"

// CreateRulesRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateRules operation. The "output" return
// value will be populated with the CreateRulesCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateRulesCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateRulesCommon Send returns without error.
//
// See CreateRules for more information on using the CreateRules
// API call, and error handling.
//
//    // Example sending a request using the CreateRulesRequest method.
//    req, resp := client.CreateRulesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ALB) CreateRulesRequest(input *CreateRulesInput) (req *request.Request, output *CreateRulesOutput) {
	op := &request.Operation{
		Name:       opCreateRules,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateRulesInput{}
	}

	output = &CreateRulesOutput{}
	req = c.newRequest(op, input, output)

	return
}

// CreateRules API operation for ALB.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ALB's
// API operation CreateRules for usage and error information.
func (c *ALB) CreateRules(input *CreateRulesInput) (*CreateRulesOutput, error) {
	req, out := c.CreateRulesRequest(input)
	return out, req.Send()
}

// CreateRulesWithContext is the same as CreateRules with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ALB) CreateRulesWithContext(ctx volcengine.Context, input *CreateRulesInput, opts ...request.Option) (*CreateRulesOutput, error) {
	req, out := c.CreateRulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateRulesInput struct {
	_ struct{} `type:"structure"`

	ListenerId *string `type:"string"`

	Rules []*RuleForCreateRulesInput `type:"list"`
}

// String returns the string representation
func (s CreateRulesInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRulesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRulesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRulesInput"}
	if s.Rules != nil {
		for i, v := range s.Rules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Rules", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetListenerId sets the ListenerId field's value.
func (s *CreateRulesInput) SetListenerId(v string) *CreateRulesInput {
	s.ListenerId = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *CreateRulesInput) SetRules(v []*RuleForCreateRulesInput) *CreateRulesInput {
	s.Rules = v
	return s
}

type CreateRulesOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	RequestId *string `type:"string"`

	RuleIds []*string `type:"list"`
}

// String returns the string representation
func (s CreateRulesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRulesOutput) GoString() string {
	return s.String()
}

// SetRequestId sets the RequestId field's value.
func (s *CreateRulesOutput) SetRequestId(v string) *CreateRulesOutput {
	s.RequestId = &v
	return s
}

// SetRuleIds sets the RuleIds field's value.
func (s *CreateRulesOutput) SetRuleIds(v []*string) *CreateRulesOutput {
	s.RuleIds = v
	return s
}

type ForwardGroupConfigForCreateRulesInput struct {
	_ struct{} `type:"structure"`

	ServerGroupTuples []*ForwardGroupConfigServerGroupTupleForCreateRulesInput `type:"list"`

	StickySessionEnabled *string `type:"string"`

	StickySessionTimeout *int64 `type:"integer"`
}

// String returns the string representation
func (s ForwardGroupConfigForCreateRulesInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ForwardGroupConfigForCreateRulesInput) GoString() string {
	return s.String()
}

// SetServerGroupTuples sets the ServerGroupTuples field's value.
func (s *ForwardGroupConfigForCreateRulesInput) SetServerGroupTuples(v []*ForwardGroupConfigServerGroupTupleForCreateRulesInput) *ForwardGroupConfigForCreateRulesInput {
	s.ServerGroupTuples = v
	return s
}

// SetStickySessionEnabled sets the StickySessionEnabled field's value.
func (s *ForwardGroupConfigForCreateRulesInput) SetStickySessionEnabled(v string) *ForwardGroupConfigForCreateRulesInput {
	s.StickySessionEnabled = &v
	return s
}

// SetStickySessionTimeout sets the StickySessionTimeout field's value.
func (s *ForwardGroupConfigForCreateRulesInput) SetStickySessionTimeout(v int64) *ForwardGroupConfigForCreateRulesInput {
	s.StickySessionTimeout = &v
	return s
}

type ForwardGroupConfigServerGroupTupleForCreateRulesInput struct {
	_ struct{} `type:"structure"`

	ServerGroupId *string `type:"string"`

	Weight *int64 `type:"integer"`
}

// String returns the string representation
func (s ForwardGroupConfigServerGroupTupleForCreateRulesInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ForwardGroupConfigServerGroupTupleForCreateRulesInput) GoString() string {
	return s.String()
}

// SetServerGroupId sets the ServerGroupId field's value.
func (s *ForwardGroupConfigServerGroupTupleForCreateRulesInput) SetServerGroupId(v string) *ForwardGroupConfigServerGroupTupleForCreateRulesInput {
	s.ServerGroupId = &v
	return s
}

// SetWeight sets the Weight field's value.
func (s *ForwardGroupConfigServerGroupTupleForCreateRulesInput) SetWeight(v int64) *ForwardGroupConfigServerGroupTupleForCreateRulesInput {
	s.Weight = &v
	return s
}

type RedirectConfigForCreateRulesInput struct {
	_ struct{} `type:"structure"`

	RedirectDomain *string `min:"1" max:"128" type:"string"`

	RedirectHttpCode *string `type:"string"`

	RedirectPort *string `type:"string"`

	RedirectProtocol *string `type:"string"`

	RedirectUri *string `min:"1" max:"128" type:"string"`
}

// String returns the string representation
func (s RedirectConfigForCreateRulesInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RedirectConfigForCreateRulesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RedirectConfigForCreateRulesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RedirectConfigForCreateRulesInput"}
	if s.RedirectDomain != nil && len(*s.RedirectDomain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RedirectDomain", 1))
	}
	if s.RedirectDomain != nil && len(*s.RedirectDomain) > 128 {
		invalidParams.Add(request.NewErrParamMaxLen("RedirectDomain", 128, *s.RedirectDomain))
	}
	if s.RedirectUri != nil && len(*s.RedirectUri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RedirectUri", 1))
	}
	if s.RedirectUri != nil && len(*s.RedirectUri) > 128 {
		invalidParams.Add(request.NewErrParamMaxLen("RedirectUri", 128, *s.RedirectUri))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRedirectDomain sets the RedirectDomain field's value.
func (s *RedirectConfigForCreateRulesInput) SetRedirectDomain(v string) *RedirectConfigForCreateRulesInput {
	s.RedirectDomain = &v
	return s
}

// SetRedirectHttpCode sets the RedirectHttpCode field's value.
func (s *RedirectConfigForCreateRulesInput) SetRedirectHttpCode(v string) *RedirectConfigForCreateRulesInput {
	s.RedirectHttpCode = &v
	return s
}

// SetRedirectPort sets the RedirectPort field's value.
func (s *RedirectConfigForCreateRulesInput) SetRedirectPort(v string) *RedirectConfigForCreateRulesInput {
	s.RedirectPort = &v
	return s
}

// SetRedirectProtocol sets the RedirectProtocol field's value.
func (s *RedirectConfigForCreateRulesInput) SetRedirectProtocol(v string) *RedirectConfigForCreateRulesInput {
	s.RedirectProtocol = &v
	return s
}

// SetRedirectUri sets the RedirectUri field's value.
func (s *RedirectConfigForCreateRulesInput) SetRedirectUri(v string) *RedirectConfigForCreateRulesInput {
	s.RedirectUri = &v
	return s
}

type RewriteConfigForCreateRulesInput struct {
	_ struct{} `type:"structure"`

	RewritePath *string `type:"string"`
}

// String returns the string representation
func (s RewriteConfigForCreateRulesInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RewriteConfigForCreateRulesInput) GoString() string {
	return s.String()
}

// SetRewritePath sets the RewritePath field's value.
func (s *RewriteConfigForCreateRulesInput) SetRewritePath(v string) *RewriteConfigForCreateRulesInput {
	s.RewritePath = &v
	return s
}

type RuleForCreateRulesInput struct {
	_ struct{} `type:"structure"`

	Description *string `type:"string"`

	Domain *string `type:"string"`

	ForwardGroupConfig *ForwardGroupConfigForCreateRulesInput `type:"structure"`

	RedirectConfig *RedirectConfigForCreateRulesInput `type:"structure"`

	RewriteConfig *RewriteConfigForCreateRulesInput `type:"structure"`

	RewriteEnabled *string `type:"string"`

	RuleAction *string `type:"string"`

	ServerGroupId *string `type:"string"`

	TrafficLimitEnabled *string `type:"string"`

	TrafficLimitQPS *int64 `type:"integer"`

	URL *string `type:"string"`
}

// String returns the string representation
func (s RuleForCreateRulesInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RuleForCreateRulesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RuleForCreateRulesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RuleForCreateRulesInput"}
	if s.RedirectConfig != nil {
		if err := s.RedirectConfig.Validate(); err != nil {
			invalidParams.AddNested("RedirectConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *RuleForCreateRulesInput) SetDescription(v string) *RuleForCreateRulesInput {
	s.Description = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *RuleForCreateRulesInput) SetDomain(v string) *RuleForCreateRulesInput {
	s.Domain = &v
	return s
}

// SetForwardGroupConfig sets the ForwardGroupConfig field's value.
func (s *RuleForCreateRulesInput) SetForwardGroupConfig(v *ForwardGroupConfigForCreateRulesInput) *RuleForCreateRulesInput {
	s.ForwardGroupConfig = v
	return s
}

// SetRedirectConfig sets the RedirectConfig field's value.
func (s *RuleForCreateRulesInput) SetRedirectConfig(v *RedirectConfigForCreateRulesInput) *RuleForCreateRulesInput {
	s.RedirectConfig = v
	return s
}

// SetRewriteConfig sets the RewriteConfig field's value.
func (s *RuleForCreateRulesInput) SetRewriteConfig(v *RewriteConfigForCreateRulesInput) *RuleForCreateRulesInput {
	s.RewriteConfig = v
	return s
}

// SetRewriteEnabled sets the RewriteEnabled field's value.
func (s *RuleForCreateRulesInput) SetRewriteEnabled(v string) *RuleForCreateRulesInput {
	s.RewriteEnabled = &v
	return s
}

// SetRuleAction sets the RuleAction field's value.
func (s *RuleForCreateRulesInput) SetRuleAction(v string) *RuleForCreateRulesInput {
	s.RuleAction = &v
	return s
}

// SetServerGroupId sets the ServerGroupId field's value.
func (s *RuleForCreateRulesInput) SetServerGroupId(v string) *RuleForCreateRulesInput {
	s.ServerGroupId = &v
	return s
}

// SetTrafficLimitEnabled sets the TrafficLimitEnabled field's value.
func (s *RuleForCreateRulesInput) SetTrafficLimitEnabled(v string) *RuleForCreateRulesInput {
	s.TrafficLimitEnabled = &v
	return s
}

// SetTrafficLimitQPS sets the TrafficLimitQPS field's value.
func (s *RuleForCreateRulesInput) SetTrafficLimitQPS(v int64) *RuleForCreateRulesInput {
	s.TrafficLimitQPS = &v
	return s
}

// SetURL sets the URL field's value.
func (s *RuleForCreateRulesInput) SetURL(v string) *RuleForCreateRulesInput {
	s.URL = &v
	return s
}
