// Example Code generated by Beijing Volcanoengine Technology.
package vpcexample

import (
	"fmt"

	"github.com/volcengine/volcengine-go-sdk/service/vpc"
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/credentials"
	"github.com/volcengine/volcengine-go-sdk/volcengine/session"
)

func DescribeSubnets() {
	ak, sk, region := "Your AK", "Your SK", "cn-beijing"
	config := volcengine.NewConfig().
		WithRegion(region).
		WithCredentials(credentials.NewStaticCredentials(ak, sk, ""))
	sess, err := session.NewSession(config)
	if err != nil {
		panic(err)
	}
	svc := vpc.New(sess)
	describeSubnetsInput := &vpc.DescribeSubnetsInput{
		VpcId:  volcengine.String("vpc-bp1b1xjllp3ve5yze****"),
		ZoneId: volcengine.String("cn-beijing-a"),
	}

	resp, err := svc.DescribeSubnets(describeSubnetsInput)
	if err != nil {
		panic(err)
	}
	fmt.Println(resp)
}
