// Copyright Project Harbor Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package auth

import (
	"net/http"

	"github.com/goharbor/harbor/src/lib/errors"
)

// apiKeyAuthorizer authorize by adding a header `X-ScannerAdapter-API-Key` with value "credential"
type apiKeyAuthorizer struct {
	typeID     string
	accessCred string
}

// Authorize the requests
func (aa *apiKeyAuthorizer) Authorize(req *http.Request) error {
	if req != nil && len(aa.accessCred) > 0 {
		req.Header.Add(aa.typeID, aa.accessCred)
		return nil
	}

	return errors.Errorf("%s: %s", aa.typeID, "missing data to authorize request")
}

// NewAPIKeyAuthorizer news a apiKeyAuthorizer
func NewAPIKeyAuthorizer(key, accessCred string) Authorizer {
	return &apiKeyAuthorizer{
		typeID:     key,
		accessCred: accessCred,
	}
}
