# Harbor Adopters

Below is a list of adopters of Harbor in **production environments** that have
publicly shared the details of their usage as well as the benefits provided by
Harbor that their business relies on. There are some unreferenceable users that
are leveraging Harbor that are not yet able to share details of their usage
publicly at this time.

There are many additional adopters of Harbor in the evaluating phase that will
be added to this list as they transition to production deployments.

<a href="https://www.jd.com" border="0" target="_blank"><img alt="JD.com" src="https://raw.githubusercontent.com/goharbor/website/main/docs/img/adopters/jd.png" height="50"></a>&nbsp; &nbsp; &nbsp;
<a href="https://www.trendmicro.com" border="0" target="_blank"><img alt="trendmicro" src="https://raw.githubusercontent.com/goharbor/website/main/docs/img/adopters/trendmicro.png" height="50"></a>&nbsp; &nbsp; &nbsp; &nbsp;
<a href="https://pitsdatenrettung.de/" target="_blank" border="0"><img alt="PITS Globale Datenrettungsdienste" src="https://raw.githubusercontent.com/goharbor/website/main/docs/img/adopters/pits-globale-datenrettungsdienste.png" height="50"></a>&nbsp; &nbsp; &nbsp; &nbsp;
<a href="https://www.datayes.com" border="0" target="_blank"><img alt="DataYes" src="https://raw.githubusercontent.com/goharbor/website/main/docs/img/adopters/datayes.png" height="50"></a>&nbsp; &nbsp; &nbsp; &nbsp;
<a href="https://www.axatp.com" border="0" target="_blank"><img alt="axatp" src="https://raw.githubusercontent.com/goharbor/website/main/docs/img/adopters/axatp.png" height="50"></a>&nbsp; &nbsp; &nbsp; &nbsp; <br/><br/>
<a href="https://www.360totalsecurity.com/en/" target="_blank" border="0"><img alt="360 Total Security" src="https://raw.githubusercontent.com/goharbor/website/main/docs/img/adopters/360.png" height="50"></a>&nbsp; &nbsp; &nbsp;
<a href="https://www.talkingdata.com" border="0" target="_blank"><img alt="talkingdata" src="https://raw.githubusercontent.com/goharbor/website/main/docs/img/adopters/talkingdata.png" height="40"></a>&nbsp; &nbsp; &nbsp; &nbsp;
<a href="http://www.boericasa.com/index.html" border="0" target="_blank"><img alt="BoerSmart" src="https://raw.githubusercontent.com/goharbor/website/main/docs/img/adopters/boer.png" height="50"></a>&nbsp; &nbsp; &nbsp; &nbsp;
<a href="http://www.open.com.cn" border="0" target="_blank"><img alt="OpenEdutainment" src="https://raw.githubusercontent.com/goharbor/website/main/docs/img/adopters/openedutainment.png" height="70"></a>&nbsp; &nbsp; &nbsp; &nbsp;
<a href="http://www.ifre.com.cn" border="0" target="_blank"><img alt="iFRE" src="https://raw.githubusercontent.com/goharbor/website/main/docs/img/adopters/ifre.png" height="50"></a>&nbsp; &nbsp; &nbsp; &nbsp; <br/><br/>
<a href="http://www.boco.com.cn:8080/bocoit/" border="0" target="_blank"><img alt="BOCOIT" src="https://raw.githubusercontent.com/goharbor/website/main/docs/img/adopters/bocoit.png" height="50"></a>&nbsp; &nbsp; &nbsp; &nbsp;
<a href="http://www.wise2c.com/" border="0" target="_blank"><img alt="wise2c" src="https://raw.githubusercontent.com/goharbor/website/main/docs/img/adopters/wise2c.png" height="50"></a>&nbsp; &nbsp; &nbsp; &nbsp;
<a href="http://www.hydsoft.com/" border="0" target="_blank"><img alt="HYDSoft" src="https://raw.githubusercontent.com/goharbor/website/main/docs/img/adopters/hydsoft.png" height="50"></a>&nbsp; &nbsp; &nbsp; &nbsp;
<a href="http://www.cloud-star.com.cn/" border="0" target="_blank"><img alt="CloudStar" src="https://raw.githubusercontent.com/goharbor/website/main/docs/img/adopters/cloudstar.png" height="50"></a>&nbsp; &nbsp; &nbsp; &nbsp;
<a href="http://www.beyondsoft.com/" border="0" target="_blank"><img alt="BeyondSoft" src="https://raw.githubusercontent.com/goharbor/website/main/docs/img/adopters/beyondsoft.png" height="50"></a>&nbsp; &nbsp; &nbsp; &nbsp;
<a href="http://www.chinamobileltd.com/" border="0" target="_blank"><img alt="ChinaMobile" src="https://raw.githubusercontent.com/goharbor/website/main/docs/img/adopters/china-mobile.png" height="50"></a>&nbsp; &nbsp; &nbsp; &nbsp;
<a href="https://www.caicloud.io" target="_blank" border="0"><img alt="CaiCloud" src="https://raw.githubusercontent.com/goharbor/website/main/docs/img/adopters/caicloud.png" height="50"></a>&nbsp; &nbsp; &nbsp; &nbsp;
<a href="https://rancher.com/" target="_blank" border="0"><img alt="Rancher" src="https://raw.githubusercontent.com/goharbor/website/main/docs/img/adopters/rancher.png" height="50"></a>&nbsp; &nbsp; &nbsp; &nbsp;
<a href="https://www.tenxcloud.com/" target="_blank" border="0"><img alt="TenxCloud" src="https://raw.githubusercontent.com/goharbor/website/main/docs/img/adopters/tenxcloud.png" height="70"></a>&nbsp; &nbsp; &nbsp; &nbsp;
<a href="http://www.bingocc.com/" target="_blank" border="0"><img alt="BingoCloud" src="https://raw.githubusercontent.com/goharbor/website/main/docs/img/adopters/bingocloud.png" height="50"></a>&nbsp; &nbsp; &nbsp; &nbsp;
<br/><br/>
<a href="http://www.slamtec.com" target="_blank" border="0"><img alt="SlamTec" src="https://raw.githubusercontent.com/goharbor/website/main/docs/img/adopters/slamtec.png" height="50"></a>&nbsp; &nbsp; &nbsp; &nbsp;
<a href="http://www.cloudchef.io/" target="_blank" border="0"><img alt="CloudChef" src="https://raw.githubusercontent.com/goharbor/website/main/docs/img/adopters/cloudchef.png" height="50"></a>&nbsp; &nbsp; &nbsp; &nbsp;
<a href="https://pivotal.io/" target="_blank" border="0"><img alt="Pivotal" src="https://raw.githubusercontent.com/goharbor/website/main/docs/img/adopters/pivotal.png" height="40"></a>&nbsp; &nbsp; &nbsp; &nbsp;
<a href="https://www.163yun.com" target="_blank" border="0"><img alt="Netease Cloud" src="https://raw.githubusercontent.com/goharbor/website/main/docs/img/adopters/wangyi.png" height="50"></a>&nbsp; &nbsp; &nbsp; &nbsp;
<a href="http://www.yanrongyun.com" target="_blank" border="0"><img alt="Yanrongyun" src="https://raw.githubusercontent.com/goharbor/website/main/docs/img/adopters/Yanrong.jpg" height="40"></a>&nbsp; &nbsp; &nbsp; &nbsp;
<a href="https://anchore.com" target="_blank" border="0"><img alt="Anchore" src="https://raw.githubusercontent.com/goharbor/website/main/docs/img/adopters/anchore_logo.png" height="40"></a>&nbsp; &nbsp; &nbsp; &nbsp;
<a href="https://www.dynatrace.com/" target="_blank" border="0"><img alt="Dynatrace" src="https://raw.githubusercontent.com/goharbor/website/main/static/img/logos/users-partners/dynatrace-logo.png"></a>&nbsp; &nbsp; &nbsp; &nbsp;
<a href="https://www.home.cern/" target="_blank" border="0">CERN</a>&nbsp; &nbsp; &nbsp; &nbsp;
<a href="https://www.ns.nl/" target="_blank" border="0"><img alt="Nederlandse Spoorwegen" src="https://raw.githubusercontent.com/goharbor/website/main/docs/img/adopters/nederlandse-spoorwegen.png" height="40"></a>&nbsp; &nbsp; &nbsp; &nbsp;
<a href="https://www.de-cix.net/" target="_blank" border="0"><img alt="DE-CIX" src="https://raw.githubusercontent.com/goharbor/website/main/docs/img/adopters/de-cix.png" height="50"></a>&nbsp; &nbsp; &nbsp; &nbsp;

## Success Stories

**JD.com:** Harbor is the registry service of JD.com’s JDOS
platform. Harbor has been used for over 2 years in production with tens of
thousands of nodes and managing millions of container images.

**China Mobile:** Harbor has been used in production for more than a year,
serving images to a container environment with over 1,000 nodes and about 20,000 images.

**360 Total Security:** Harbor is used to distribute images and manage access
to project images at 360 Total Security. The image replication function is
heavily leveraged in their environment. Harbor supports approximately 800
compute nodes in production environments across different regions and manages
about 20,000 container images.

**Slamtec:** Harbor is being used in external production systems as well as
internal dev/test environments. All services are deployed using container
images stored and managed by Harbor, making Harbor an important part of
Slamtec's CI/CD workflow.

**Bingo Cloud:** Bingo cloud OS uses Harbor as their ECR (Elastic Container
Registry) component. Harbor allows them to have project-based image management
in private cloud environment of large enterprises. Harbor has been deployed in
some large state-owned or province-owned enterprises.

**Union Pay:** Union Pay adopts Harbor to manage container images for more than
200 nodes. Harbor enforces RBAC and vulnerability scanning on images used in
the production environment.

**Minsheng Life Insurance:** Harbor is used to build a private image registry.
It manages base images of all application services and the container images
created in project development. Harbor is integrated with the container cloud
platform through its RESTful API. Harbor supports about 40 nodes in a cluster
and manages more than 3,000 images.

**Priority Payment Systems:** Harbor has been an integral component in our
CI/CD pipeline for more than a year housing hundreds of images for various
environments.

**AWN:** Utilizes Harbor as a secure image repository for all internal
container-based workloads. Harbor provides developers and sysadmins a secure
and easy-to-use repository. AWN leverages the image vulnerability scanning
feature within Harbor before deploying images into production.

**Allegis:** Harbor is used at Allegis as a secure private registry to store
and scan customized container images for different business applications, like
ELK stack, as part of their CI/CD pipeline.

**DE-CIX:** Harbor has been integrated into the application stack to replace the former hosted Docker registry, now known as the Distribution Registry. With Harbor, we have started separating access to project-related images using OIDC group mapping and robot accounts with dedicated permissions. Another significant benefit comes with the implemented vulnerability scanner, which makes vulnerabilities more transparent to our teams.

## Adding your logo

If you would like to add your logo here and to the `Users and Partners of Harbor` section of the website, add a PNG or SVG version of your logo to the [adopters](https://github.com/goharbor/website/tree/main/docs/img/adopters) directory of the [website](https://github.com/goharbor/website) and submit a pull request with your change. Name the image file something that reflects your company (e.g., if your company is called Acme, name the image acme.png). We will follow up and make the change in the goharbor.io website as well.
