// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package cr

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opListTagsCommon = "ListTags"

// ListTagsCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ListTagsCommon operation. The "output" return
// value will be populated with the ListTagsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListTagsCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListTagsCommon Send returns without error.
//
// See ListTagsCommon for more information on using the ListTagsCommon
// API call, and error handling.
//
//    // Example sending a request using the ListTagsCommonRequest method.
//    req, resp := client.ListTagsCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CR) ListTagsCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opListTagsCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListTagsCommon API operation for CR.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CR's
// API operation ListTagsCommon for usage and error information.
func (c *CR) ListTagsCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ListTagsCommonRequest(input)
	return out, req.Send()
}

// ListTagsCommonWithContext is the same as ListTagsCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CR) ListTagsCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ListTagsCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTags = "ListTags"

// ListTagsRequest generates a "volcengine/request.Request" representing the
// client's request for the ListTags operation. The "output" return
// value will be populated with the ListTagsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListTagsCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListTagsCommon Send returns without error.
//
// See ListTags for more information on using the ListTags
// API call, and error handling.
//
//    // Example sending a request using the ListTagsRequest method.
//    req, resp := client.ListTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CR) ListTagsRequest(input *ListTagsInput) (req *request.Request, output *ListTagsOutput) {
	op := &request.Operation{
		Name:       opListTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsInput{}
	}

	output = &ListTagsOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListTags API operation for CR.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CR's
// API operation ListTags for usage and error information.
func (c *CR) ListTags(input *ListTagsInput) (*ListTagsOutput, error) {
	req, out := c.ListTagsRequest(input)
	return out, req.Send()
}

// ListTagsWithContext is the same as ListTags with the addition of
// the ability to pass a context and additional request options.
//
// See ListTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CR) ListTagsWithContext(ctx volcengine.Context, input *ListTagsInput, opts ...request.Option) (*ListTagsOutput, error) {
	req, out := c.ListTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ChartAttributeForListTagsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ApiVersion *string `type:"string" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	Version *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ChartAttributeForListTagsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ChartAttributeForListTagsOutput) GoString() string {
	return s.String()
}

// SetApiVersion sets the ApiVersion field's value.
func (s *ChartAttributeForListTagsOutput) SetApiVersion(v string) *ChartAttributeForListTagsOutput {
	s.ApiVersion = &v
	return s
}

// SetName sets the Name field's value.
func (s *ChartAttributeForListTagsOutput) SetName(v string) *ChartAttributeForListTagsOutput {
	s.Name = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *ChartAttributeForListTagsOutput) SetVersion(v string) *ChartAttributeForListTagsOutput {
	s.Version = &v
	return s
}

type FilterForListTagsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Names []*string `type:"list" json:",omitempty"`

	Types []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s FilterForListTagsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s FilterForListTagsInput) GoString() string {
	return s.String()
}

// SetNames sets the Names field's value.
func (s *FilterForListTagsInput) SetNames(v []*string) *FilterForListTagsInput {
	s.Names = v
	return s
}

// SetTypes sets the Types field's value.
func (s *FilterForListTagsInput) SetTypes(v []*string) *FilterForListTagsInput {
	s.Types = v
	return s
}

type ImageAttributeForListTagsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Architecture *string `type:"string" json:",omitempty"`

	Author *string `type:"string" json:",omitempty"`

	Digest *string `type:"string" json:",omitempty"`

	Os *string `type:"string" json:",omitempty"`

	Size *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s ImageAttributeForListTagsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ImageAttributeForListTagsOutput) GoString() string {
	return s.String()
}

// SetArchitecture sets the Architecture field's value.
func (s *ImageAttributeForListTagsOutput) SetArchitecture(v string) *ImageAttributeForListTagsOutput {
	s.Architecture = &v
	return s
}

// SetAuthor sets the Author field's value.
func (s *ImageAttributeForListTagsOutput) SetAuthor(v string) *ImageAttributeForListTagsOutput {
	s.Author = &v
	return s
}

// SetDigest sets the Digest field's value.
func (s *ImageAttributeForListTagsOutput) SetDigest(v string) *ImageAttributeForListTagsOutput {
	s.Digest = &v
	return s
}

// SetOs sets the Os field's value.
func (s *ImageAttributeForListTagsOutput) SetOs(v string) *ImageAttributeForListTagsOutput {
	s.Os = &v
	return s
}

// SetSize sets the Size field's value.
func (s *ImageAttributeForListTagsOutput) SetSize(v int64) *ImageAttributeForListTagsOutput {
	s.Size = &v
	return s
}

type ItemForListTagsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ChartAttribute *ChartAttributeForListTagsOutput `type:"structure" json:",omitempty"`

	Digest *string `type:"string" json:",omitempty"`

	ImageAttributes []*ImageAttributeForListTagsOutput `type:"list" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	PushTime *string `type:"string" json:",omitempty"`

	Size *int64 `type:"int64" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ItemForListTagsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ItemForListTagsOutput) GoString() string {
	return s.String()
}

// SetChartAttribute sets the ChartAttribute field's value.
func (s *ItemForListTagsOutput) SetChartAttribute(v *ChartAttributeForListTagsOutput) *ItemForListTagsOutput {
	s.ChartAttribute = v
	return s
}

// SetDigest sets the Digest field's value.
func (s *ItemForListTagsOutput) SetDigest(v string) *ItemForListTagsOutput {
	s.Digest = &v
	return s
}

// SetImageAttributes sets the ImageAttributes field's value.
func (s *ItemForListTagsOutput) SetImageAttributes(v []*ImageAttributeForListTagsOutput) *ItemForListTagsOutput {
	s.ImageAttributes = v
	return s
}

// SetName sets the Name field's value.
func (s *ItemForListTagsOutput) SetName(v string) *ItemForListTagsOutput {
	s.Name = &v
	return s
}

// SetPushTime sets the PushTime field's value.
func (s *ItemForListTagsOutput) SetPushTime(v string) *ItemForListTagsOutput {
	s.PushTime = &v
	return s
}

// SetSize sets the Size field's value.
func (s *ItemForListTagsOutput) SetSize(v int64) *ItemForListTagsOutput {
	s.Size = &v
	return s
}

// SetType sets the Type field's value.
func (s *ItemForListTagsOutput) SetType(v string) *ItemForListTagsOutput {
	s.Type = &v
	return s
}

type ListTagsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Filter *FilterForListTagsInput `type:"structure" json:",omitempty"`

	// Namespace is a required field
	Namespace *string `min:"2" max:"90" type:"string" json:",omitempty" required:"true"`

	PageNumber *int64 `type:"int64" json:",omitempty"`

	PageSize *int64 `min:"1" max:"100" type:"int64" json:",omitempty"`

	// Registry is a required field
	Registry *string `min:"3" max:"30" type:"string" json:",omitempty" required:"true"`

	// Repository is a required field
	Repository *string `type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s ListTagsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsInput"}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 2))
	}
	if s.Namespace != nil && len(*s.Namespace) > 90 {
		invalidParams.Add(request.NewErrParamMaxLen("Namespace", 90, *s.Namespace))
	}
	if s.PageSize != nil && *s.PageSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PageSize", 1))
	}
	if s.PageSize != nil && *s.PageSize > 100 {
		invalidParams.Add(request.NewErrParamMaxValue("PageSize", 100))
	}
	if s.Registry == nil {
		invalidParams.Add(request.NewErrParamRequired("Registry"))
	}
	if s.Registry != nil && len(*s.Registry) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Registry", 3))
	}
	if s.Registry != nil && len(*s.Registry) > 30 {
		invalidParams.Add(request.NewErrParamMaxLen("Registry", 30, *s.Registry))
	}
	if s.Repository == nil {
		invalidParams.Add(request.NewErrParamRequired("Repository"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListTagsInput) SetFilter(v *FilterForListTagsInput) *ListTagsInput {
	s.Filter = v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *ListTagsInput) SetNamespace(v string) *ListTagsInput {
	s.Namespace = &v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListTagsInput) SetPageNumber(v int64) *ListTagsInput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListTagsInput) SetPageSize(v int64) *ListTagsInput {
	s.PageSize = &v
	return s
}

// SetRegistry sets the Registry field's value.
func (s *ListTagsInput) SetRegistry(v string) *ListTagsInput {
	s.Registry = &v
	return s
}

// SetRepository sets the Repository field's value.
func (s *ListTagsInput) SetRepository(v string) *ListTagsInput {
	s.Repository = &v
	return s
}

type ListTagsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Items []*ItemForListTagsOutput `type:"list" json:",omitempty"`

	Namespace *string `type:"string" json:",omitempty"`

	PageNumber *int64 `type:"int64" json:",omitempty"`

	PageSize *int64 `type:"int64" json:",omitempty"`

	Registry *string `type:"string" json:",omitempty"`

	Repository *string `type:"string" json:",omitempty"`

	TotalCount *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s ListTagsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListTagsOutput) SetItems(v []*ItemForListTagsOutput) *ListTagsOutput {
	s.Items = v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *ListTagsOutput) SetNamespace(v string) *ListTagsOutput {
	s.Namespace = &v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListTagsOutput) SetPageNumber(v int64) *ListTagsOutput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListTagsOutput) SetPageSize(v int64) *ListTagsOutput {
	s.PageSize = &v
	return s
}

// SetRegistry sets the Registry field's value.
func (s *ListTagsOutput) SetRegistry(v string) *ListTagsOutput {
	s.Registry = &v
	return s
}

// SetRepository sets the Repository field's value.
func (s *ListTagsOutput) SetRepository(v string) *ListTagsOutput {
	s.Repository = &v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *ListTagsOutput) SetTotalCount(v int64) *ListTagsOutput {
	s.TotalCount = &v
	return s
}
