package yundun_bastionhost

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeInstanceOperationTicket invokes the yundun_bastionhost.DescribeInstanceOperationTicket API synchronously
// api document: https://help.aliyun.com/api/yundun-bastionhost/describeinstanceoperationticket.html
func (client *Client) DescribeInstanceOperationTicket(request *DescribeInstanceOperationTicketRequest) (response *DescribeInstanceOperationTicketResponse, err error) {
	response = CreateDescribeInstanceOperationTicketResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeInstanceOperationTicketWithChan invokes the yundun_bastionhost.DescribeInstanceOperationTicket API asynchronously
// api document: https://help.aliyun.com/api/yundun-bastionhost/describeinstanceoperationticket.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeInstanceOperationTicketWithChan(request *DescribeInstanceOperationTicketRequest) (<-chan *DescribeInstanceOperationTicketResponse, <-chan error) {
	responseChan := make(chan *DescribeInstanceOperationTicketResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeInstanceOperationTicket(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeInstanceOperationTicketWithCallback invokes the yundun_bastionhost.DescribeInstanceOperationTicket API asynchronously
// api document: https://help.aliyun.com/api/yundun-bastionhost/describeinstanceoperationticket.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeInstanceOperationTicketWithCallback(request *DescribeInstanceOperationTicketRequest, callback func(response *DescribeInstanceOperationTicketResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeInstanceOperationTicketResponse
		var err error
		defer close(result)
		response, err = client.DescribeInstanceOperationTicket(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeInstanceOperationTicketRequest is the request struct for api DescribeInstanceOperationTicket
type DescribeInstanceOperationTicketRequest struct {
	*requests.RpcRequest
	Target     string `position:"Query" name:"Target"`
	InstanceId string `position:"Query" name:"InstanceId"`
	SourceIp   string `position:"Query" name:"SourceIp"`
	Lang       string `position:"Query" name:"Lang"`
}

// DescribeInstanceOperationTicketResponse is the response struct for api DescribeInstanceOperationTicket
type DescribeInstanceOperationTicketResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	StsToken  StsToken `json:"StsToken" xml:"StsToken"`
}

// CreateDescribeInstanceOperationTicketRequest creates a request to invoke DescribeInstanceOperationTicket API
func CreateDescribeInstanceOperationTicketRequest() (request *DescribeInstanceOperationTicketRequest) {
	request = &DescribeInstanceOperationTicketRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Yundun-bastionhost", "2018-10-10", "DescribeInstanceOperationTicket", "bastionhost", "openAPI")
	return
}

// CreateDescribeInstanceOperationTicketResponse creates a response to parse from DescribeInstanceOperationTicket response
func CreateDescribeInstanceOperationTicketResponse() (response *DescribeInstanceOperationTicketResponse) {
	response = &DescribeInstanceOperationTicketResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
