package waf_openapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeRuleGroups invokes the waf_openapi.DescribeRuleGroups API synchronously
func (client *Client) DescribeRuleGroups(request *DescribeRuleGroupsRequest) (response *DescribeRuleGroupsResponse, err error) {
	response = CreateDescribeRuleGroupsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeRuleGroupsWithChan invokes the waf_openapi.DescribeRuleGroups API asynchronously
func (client *Client) DescribeRuleGroupsWithChan(request *DescribeRuleGroupsRequest) (<-chan *DescribeRuleGroupsResponse, <-chan error) {
	responseChan := make(chan *DescribeRuleGroupsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeRuleGroups(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeRuleGroupsWithCallback invokes the waf_openapi.DescribeRuleGroups API asynchronously
func (client *Client) DescribeRuleGroupsWithCallback(request *DescribeRuleGroupsRequest, callback func(response *DescribeRuleGroupsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeRuleGroupsResponse
		var err error
		defer close(result)
		response, err = client.DescribeRuleGroups(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeRuleGroupsRequest is the request struct for api DescribeRuleGroups
type DescribeRuleGroupsRequest struct {
	*requests.RpcRequest
	Type            requests.Integer `position:"Query" name:"Type"`
	WafLang         string           `position:"Query" name:"WafLang"`
	ResourceGroupId string           `position:"Query" name:"ResourceGroupId"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
	PolicyId        requests.Integer `position:"Query" name:"PolicyId"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	Lang            string           `position:"Query" name:"Lang"`
	CurrentPage     requests.Integer `position:"Query" name:"CurrentPage"`
	InstanceId      string           `position:"Query" name:"InstanceId"`
	Region          string           `position:"Query" name:"Region"`
}

// DescribeRuleGroupsResponse is the response struct for api DescribeRuleGroups
type DescribeRuleGroupsResponse struct {
	*responses.BaseResponse
	RequestId  string           `json:"RequestId" xml:"RequestId"`
	TaskStatus int              `json:"TaskStatus" xml:"TaskStatus"`
	Total      int              `json:"Total" xml:"Total"`
	WafTaskId  string           `json:"WafTaskId" xml:"WafTaskId"`
	RuleGroups []RuleGroupsItem `json:"RuleGroups" xml:"RuleGroups"`
}

// CreateDescribeRuleGroupsRequest creates a request to invoke DescribeRuleGroups API
func CreateDescribeRuleGroupsRequest() (request *DescribeRuleGroupsRequest) {
	request = &DescribeRuleGroupsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("waf-openapi", "2019-09-10", "DescribeRuleGroups", "waf", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeRuleGroupsResponse creates a response to parse from DescribeRuleGroups response
func CreateDescribeRuleGroupsResponse() (response *DescribeRuleGroupsResponse) {
	response = &DescribeRuleGroupsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
