package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVsDomainBpsData invokes the vs.DescribeVsDomainBpsData API synchronously
func (client *Client) DescribeVsDomainBpsData(request *DescribeVsDomainBpsDataRequest) (response *DescribeVsDomainBpsDataResponse, err error) {
	response = CreateDescribeVsDomainBpsDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVsDomainBpsDataWithChan invokes the vs.DescribeVsDomainBpsData API asynchronously
func (client *Client) DescribeVsDomainBpsDataWithChan(request *DescribeVsDomainBpsDataRequest) (<-chan *DescribeVsDomainBpsDataResponse, <-chan error) {
	responseChan := make(chan *DescribeVsDomainBpsDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVsDomainBpsData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVsDomainBpsDataWithCallback invokes the vs.DescribeVsDomainBpsData API asynchronously
func (client *Client) DescribeVsDomainBpsDataWithCallback(request *DescribeVsDomainBpsDataRequest, callback func(response *DescribeVsDomainBpsDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVsDomainBpsDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeVsDomainBpsData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVsDomainBpsDataRequest is the request struct for api DescribeVsDomainBpsData
type DescribeVsDomainBpsDataRequest struct {
	*requests.RpcRequest
	LocationNameEn string           `position:"Query" name:"LocationNameEn"`
	StartTime      string           `position:"Query" name:"StartTime"`
	IspNameEn      string           `position:"Query" name:"IspNameEn"`
	ShowLog        string           `position:"Query" name:"ShowLog"`
	DomainName     string           `position:"Query" name:"DomainName"`
	EndTime        string           `position:"Query" name:"EndTime"`
	OwnerId        requests.Integer `position:"Query" name:"OwnerId"`
	Interval       string           `position:"Query" name:"Interval"`
}

// DescribeVsDomainBpsDataResponse is the response struct for api DescribeVsDomainBpsData
type DescribeVsDomainBpsDataResponse struct {
	*responses.BaseResponse
	EndTime            string             `json:"EndTime" xml:"EndTime"`
	StartTime          string             `json:"StartTime" xml:"StartTime"`
	RequestId          string             `json:"RequestId" xml:"RequestId"`
	DomainName         string             `json:"DomainName" xml:"DomainName"`
	DataInterval       string             `json:"DataInterval" xml:"DataInterval"`
	BpsDataPerInterval BpsDataPerInterval `json:"BpsDataPerInterval" xml:"BpsDataPerInterval"`
}

// CreateDescribeVsDomainBpsDataRequest creates a request to invoke DescribeVsDomainBpsData API
func CreateDescribeVsDomainBpsDataRequest() (request *DescribeVsDomainBpsDataRequest) {
	request = &DescribeVsDomainBpsDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "DescribeVsDomainBpsData", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeVsDomainBpsDataResponse creates a response to parse from DescribeVsDomainBpsData response
func CreateDescribeVsDomainBpsDataResponse() (response *DescribeVsDomainBpsDataResponse) {
	response = &DescribeVsDomainBpsDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
