package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeGroup invokes the vs.DescribeGroup API synchronously
func (client *Client) DescribeGroup(request *DescribeGroupRequest) (response *DescribeGroupResponse, err error) {
	response = CreateDescribeGroupResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeGroupWithChan invokes the vs.DescribeGroup API asynchronously
func (client *Client) DescribeGroupWithChan(request *DescribeGroupRequest) (<-chan *DescribeGroupResponse, <-chan error) {
	responseChan := make(chan *DescribeGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeGroupWithCallback invokes the vs.DescribeGroup API asynchronously
func (client *Client) DescribeGroupWithCallback(request *DescribeGroupRequest, callback func(response *DescribeGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeGroupResponse
		var err error
		defer close(result)
		response, err = client.DescribeGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeGroupRequest is the request struct for api DescribeGroup
type DescribeGroupRequest struct {
	*requests.RpcRequest
	IncludeStats requests.Boolean `position:"Query" name:"IncludeStats"`
	Id           string           `position:"Query" name:"Id"`
	ShowLog      string           `position:"Query" name:"ShowLog"`
	OwnerId      requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeGroupResponse is the response struct for api DescribeGroup
type DescribeGroupResponse struct {
	*responses.BaseResponse
	Status           string   `json:"Status" xml:"Status"`
	LazyPull         bool     `json:"LazyPull" xml:"LazyPull"`
	Callback         string   `json:"Callback" xml:"Callback"`
	RequestId        string   `json:"RequestId" xml:"RequestId"`
	Description      string   `json:"Description" xml:"Description"`
	App              string   `json:"App" xml:"App"`
	Region           string   `json:"Region" xml:"Region"`
	Enabled          bool     `json:"Enabled" xml:"Enabled"`
	InProtocol       string   `json:"InProtocol" xml:"InProtocol"`
	OutProtocol      string   `json:"OutProtocol" xml:"OutProtocol"`
	Name             string   `json:"Name" xml:"Name"`
	PushDomain       string   `json:"PushDomain" xml:"PushDomain"`
	CreatedTime      string   `json:"CreatedTime" xml:"CreatedTime"`
	CaptureVideo     int      `json:"CaptureVideo" xml:"CaptureVideo"`
	PlayDomain       string   `json:"PlayDomain" xml:"PlayDomain"`
	CaptureInterval  int      `json:"CaptureInterval" xml:"CaptureInterval"`
	GbPort           int64    `json:"GbPort" xml:"GbPort"`
	GbId             string   `json:"GbId" xml:"GbId"`
	GbIp             string   `json:"GbIp" xml:"GbIp"`
	CaptureImage     int      `json:"CaptureImage" xml:"CaptureImage"`
	AliasId          string   `json:"AliasId" xml:"AliasId"`
	CaptureOssBucket string   `json:"CaptureOssBucket" xml:"CaptureOssBucket"`
	CaptureOssPath   string   `json:"CaptureOssPath" xml:"CaptureOssPath"`
	Id               string   `json:"Id" xml:"Id"`
	GbTcpPorts       []string `json:"GbTcpPorts" xml:"GbTcpPorts"`
	GbUdpPorts       []string `json:"GbUdpPorts" xml:"GbUdpPorts"`
	Stats            Stats    `json:"Stats" xml:"Stats"`
}

// CreateDescribeGroupRequest creates a request to invoke DescribeGroup API
func CreateDescribeGroupRequest() (request *DescribeGroupRequest) {
	request = &DescribeGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "DescribeGroup", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeGroupResponse creates a response to parse from DescribeGroup response
func CreateDescribeGroupResponse() (response *DescribeGroupResponse) {
	response = &DescribeGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
