package vpcpeer

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RejectVpcPeerConnection invokes the vpcpeer.RejectVpcPeerConnection API synchronously
func (client *Client) RejectVpcPeerConnection(request *RejectVpcPeerConnectionRequest) (response *RejectVpcPeerConnectionResponse, err error) {
	response = CreateRejectVpcPeerConnectionResponse()
	err = client.DoAction(request, response)
	return
}

// RejectVpcPeerConnectionWithChan invokes the vpcpeer.RejectVpcPeerConnection API asynchronously
func (client *Client) RejectVpcPeerConnectionWithChan(request *RejectVpcPeerConnectionRequest) (<-chan *RejectVpcPeerConnectionResponse, <-chan error) {
	responseChan := make(chan *RejectVpcPeerConnectionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RejectVpcPeerConnection(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RejectVpcPeerConnectionWithCallback invokes the vpcpeer.RejectVpcPeerConnection API asynchronously
func (client *Client) RejectVpcPeerConnectionWithCallback(request *RejectVpcPeerConnectionRequest, callback func(response *RejectVpcPeerConnectionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RejectVpcPeerConnectionResponse
		var err error
		defer close(result)
		response, err = client.RejectVpcPeerConnection(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RejectVpcPeerConnectionRequest is the request struct for api RejectVpcPeerConnection
type RejectVpcPeerConnectionRequest struct {
	*requests.RpcRequest
	ClientToken          string           `position:"Body" name:"ClientToken"`
	Channel              string           `position:"Body" name:"Channel"`
	DryRun               requests.Boolean `position:"Body" name:"DryRun"`
	ResourceOwnerAccount string           `position:"Body" name:"ResourceOwnerAccount"`
	InstanceId           string           `position:"Body" name:"InstanceId"`
}

// RejectVpcPeerConnectionResponse is the response struct for api RejectVpcPeerConnection
type RejectVpcPeerConnectionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateRejectVpcPeerConnectionRequest creates a request to invoke RejectVpcPeerConnection API
func CreateRejectVpcPeerConnectionRequest() (request *RejectVpcPeerConnectionRequest) {
	request = &RejectVpcPeerConnectionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("VpcPeer", "2022-01-01", "RejectVpcPeerConnection", "vpcpeer", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRejectVpcPeerConnectionResponse creates a response to parse from RejectVpcPeerConnection response
func CreateRejectVpcPeerConnectionResponse() (response *RejectVpcPeerConnectionResponse) {
	response = &RejectVpcPeerConnectionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
