package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StopFailoverTestJob invokes the vpc.StopFailoverTestJob API synchronously
func (client *Client) StopFailoverTestJob(request *StopFailoverTestJobRequest) (response *StopFailoverTestJobResponse, err error) {
	response = CreateStopFailoverTestJobResponse()
	err = client.DoAction(request, response)
	return
}

// StopFailoverTestJobWithChan invokes the vpc.StopFailoverTestJob API asynchronously
func (client *Client) StopFailoverTestJobWithChan(request *StopFailoverTestJobRequest) (<-chan *StopFailoverTestJobResponse, <-chan error) {
	responseChan := make(chan *StopFailoverTestJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StopFailoverTestJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StopFailoverTestJobWithCallback invokes the vpc.StopFailoverTestJob API asynchronously
func (client *Client) StopFailoverTestJobWithCallback(request *StopFailoverTestJobRequest, callback func(response *StopFailoverTestJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StopFailoverTestJobResponse
		var err error
		defer close(result)
		response, err = client.StopFailoverTestJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StopFailoverTestJobRequest is the request struct for api StopFailoverTestJob
type StopFailoverTestJobRequest struct {
	*requests.RpcRequest
	ClientToken          string           `position:"Query" name:"ClientToken"`
	JobId                string           `position:"Query" name:"JobId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// StopFailoverTestJobResponse is the response struct for api StopFailoverTestJob
type StopFailoverTestJobResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateStopFailoverTestJobRequest creates a request to invoke StopFailoverTestJob API
func CreateStopFailoverTestJobRequest() (request *StopFailoverTestJobRequest) {
	request = &StopFailoverTestJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "StopFailoverTestJob", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateStopFailoverTestJobResponse creates a response to parse from StopFailoverTestJob response
func CreateStopFailoverTestJobResponse() (response *StopFailoverTestJobResponse) {
	response = &StopFailoverTestJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
