package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ReleaseIpv6Address invokes the vpc.ReleaseIpv6Address API synchronously
func (client *Client) ReleaseIpv6Address(request *ReleaseIpv6AddressRequest) (response *ReleaseIpv6AddressResponse, err error) {
	response = CreateReleaseIpv6AddressResponse()
	err = client.DoAction(request, response)
	return
}

// ReleaseIpv6AddressWithChan invokes the vpc.ReleaseIpv6Address API asynchronously
func (client *Client) ReleaseIpv6AddressWithChan(request *ReleaseIpv6AddressRequest) (<-chan *ReleaseIpv6AddressResponse, <-chan error) {
	responseChan := make(chan *ReleaseIpv6AddressResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ReleaseIpv6Address(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ReleaseIpv6AddressWithCallback invokes the vpc.ReleaseIpv6Address API asynchronously
func (client *Client) ReleaseIpv6AddressWithCallback(request *ReleaseIpv6AddressRequest, callback func(response *ReleaseIpv6AddressResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ReleaseIpv6AddressResponse
		var err error
		defer close(result)
		response, err = client.ReleaseIpv6Address(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ReleaseIpv6AddressRequest is the request struct for api ReleaseIpv6Address
type ReleaseIpv6AddressRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	DryRun               requests.Boolean `position:"Query" name:"DryRun"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	Ipv6AddressId        string           `position:"Query" name:"Ipv6AddressId"`
}

// ReleaseIpv6AddressResponse is the response struct for api ReleaseIpv6Address
type ReleaseIpv6AddressResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateReleaseIpv6AddressRequest creates a request to invoke ReleaseIpv6Address API
func CreateReleaseIpv6AddressRequest() (request *ReleaseIpv6AddressRequest) {
	request = &ReleaseIpv6AddressRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "ReleaseIpv6Address", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateReleaseIpv6AddressResponse creates a response to parse from ReleaseIpv6Address response
func CreateReleaseIpv6AddressResponse() (response *ReleaseIpv6AddressResponse) {
	response = &ReleaseIpv6AddressResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
