package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// MoveVpnResourceGroup invokes the vpc.MoveVpnResourceGroup API synchronously
func (client *Client) MoveVpnResourceGroup(request *MoveVpnResourceGroupRequest) (response *MoveVpnResourceGroupResponse, err error) {
	response = CreateMoveVpnResourceGroupResponse()
	err = client.DoAction(request, response)
	return
}

// MoveVpnResourceGroupWithChan invokes the vpc.MoveVpnResourceGroup API asynchronously
func (client *Client) MoveVpnResourceGroupWithChan(request *MoveVpnResourceGroupRequest) (<-chan *MoveVpnResourceGroupResponse, <-chan error) {
	responseChan := make(chan *MoveVpnResourceGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.MoveVpnResourceGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// MoveVpnResourceGroupWithCallback invokes the vpc.MoveVpnResourceGroup API asynchronously
func (client *Client) MoveVpnResourceGroupWithCallback(request *MoveVpnResourceGroupRequest, callback func(response *MoveVpnResourceGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *MoveVpnResourceGroupResponse
		var err error
		defer close(result)
		response, err = client.MoveVpnResourceGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// MoveVpnResourceGroupRequest is the request struct for api MoveVpnResourceGroup
type MoveVpnResourceGroupRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	ResourceType         string           `position:"Query" name:"ResourceType"`
	InstanceId           string           `position:"Query" name:"InstanceId"`
	NewResourceGroupId   string           `position:"Query" name:"NewResourceGroupId"`
}

// MoveVpnResourceGroupResponse is the response struct for api MoveVpnResourceGroup
type MoveVpnResourceGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateMoveVpnResourceGroupRequest creates a request to invoke MoveVpnResourceGroup API
func CreateMoveVpnResourceGroupRequest() (request *MoveVpnResourceGroupRequest) {
	request = &MoveVpnResourceGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "MoveVpnResourceGroup", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateMoveVpnResourceGroupResponse creates a response to parse from MoveVpnResourceGroup response
func CreateMoveVpnResourceGroupResponse() (response *MoveVpnResourceGroupResponse) {
	response = &MoveVpnResourceGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
