package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListBusinessAccessPoints invokes the vpc.ListBusinessAccessPoints API synchronously
func (client *Client) ListBusinessAccessPoints(request *ListBusinessAccessPointsRequest) (response *ListBusinessAccessPointsResponse, err error) {
	response = CreateListBusinessAccessPointsResponse()
	err = client.DoAction(request, response)
	return
}

// ListBusinessAccessPointsWithChan invokes the vpc.ListBusinessAccessPoints API asynchronously
func (client *Client) ListBusinessAccessPointsWithChan(request *ListBusinessAccessPointsRequest) (<-chan *ListBusinessAccessPointsResponse, <-chan error) {
	responseChan := make(chan *ListBusinessAccessPointsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListBusinessAccessPoints(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListBusinessAccessPointsWithCallback invokes the vpc.ListBusinessAccessPoints API asynchronously
func (client *Client) ListBusinessAccessPointsWithCallback(request *ListBusinessAccessPointsRequest, callback func(response *ListBusinessAccessPointsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListBusinessAccessPointsResponse
		var err error
		defer close(result)
		response, err = client.ListBusinessAccessPoints(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListBusinessAccessPointsRequest is the request struct for api ListBusinessAccessPoints
type ListBusinessAccessPointsRequest struct {
	*requests.RpcRequest
}

// ListBusinessAccessPointsResponse is the response struct for api ListBusinessAccessPoints
type ListBusinessAccessPointsResponse struct {
	*responses.BaseResponse
	RequestId            string                     `json:"RequestId" xml:"RequestId"`
	BusinessAccessPoints []BusinessAccessPointsItem `json:"BusinessAccessPoints" xml:"BusinessAccessPoints"`
}

// CreateListBusinessAccessPointsRequest creates a request to invoke ListBusinessAccessPoints API
func CreateListBusinessAccessPointsRequest() (request *ListBusinessAccessPointsRequest) {
	request = &ListBusinessAccessPointsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "ListBusinessAccessPoints", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListBusinessAccessPointsResponse creates a response to parse from ListBusinessAccessPoints response
func CreateListBusinessAccessPointsResponse() (response *ListBusinessAccessPointsResponse) {
	response = &ListBusinessAccessPointsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
