package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetFlowLogServiceStatus invokes the vpc.GetFlowLogServiceStatus API synchronously
func (client *Client) GetFlowLogServiceStatus(request *GetFlowLogServiceStatusRequest) (response *GetFlowLogServiceStatusResponse, err error) {
	response = CreateGetFlowLogServiceStatusResponse()
	err = client.DoAction(request, response)
	return
}

// GetFlowLogServiceStatusWithChan invokes the vpc.GetFlowLogServiceStatus API asynchronously
func (client *Client) GetFlowLogServiceStatusWithChan(request *GetFlowLogServiceStatusRequest) (<-chan *GetFlowLogServiceStatusResponse, <-chan error) {
	responseChan := make(chan *GetFlowLogServiceStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetFlowLogServiceStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetFlowLogServiceStatusWithCallback invokes the vpc.GetFlowLogServiceStatus API asynchronously
func (client *Client) GetFlowLogServiceStatusWithCallback(request *GetFlowLogServiceStatusRequest, callback func(response *GetFlowLogServiceStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetFlowLogServiceStatusResponse
		var err error
		defer close(result)
		response, err = client.GetFlowLogServiceStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetFlowLogServiceStatusRequest is the request struct for api GetFlowLogServiceStatus
type GetFlowLogServiceStatusRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// GetFlowLogServiceStatusResponse is the response struct for api GetFlowLogServiceStatus
type GetFlowLogServiceStatusResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Enabled   bool   `json:"Enabled" xml:"Enabled"`
}

// CreateGetFlowLogServiceStatusRequest creates a request to invoke GetFlowLogServiceStatus API
func CreateGetFlowLogServiceStatusRequest() (request *GetFlowLogServiceStatusRequest) {
	request = &GetFlowLogServiceStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "GetFlowLogServiceStatus", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetFlowLogServiceStatusResponse creates a response to parse from GetFlowLogServiceStatus response
func CreateGetFlowLogServiceStatusResponse() (response *GetFlowLogServiceStatusResponse) {
	response = &GetFlowLogServiceStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
