package voicenavigator

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SaveRecording invokes the voicenavigator.SaveRecording API synchronously
func (client *Client) SaveRecording(request *SaveRecordingRequest) (response *SaveRecordingResponse, err error) {
	response = CreateSaveRecordingResponse()
	err = client.DoAction(request, response)
	return
}

// SaveRecordingWithChan invokes the voicenavigator.SaveRecording API asynchronously
func (client *Client) SaveRecordingWithChan(request *SaveRecordingRequest) (<-chan *SaveRecordingResponse, <-chan error) {
	responseChan := make(chan *SaveRecordingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SaveRecording(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SaveRecordingWithCallback invokes the voicenavigator.SaveRecording API asynchronously
func (client *Client) SaveRecordingWithCallback(request *SaveRecordingRequest, callback func(response *SaveRecordingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SaveRecordingResponse
		var err error
		defer close(result)
		response, err = client.SaveRecording(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SaveRecordingRequest is the request struct for api SaveRecording
type SaveRecordingRequest struct {
	*requests.RpcRequest
	VoiceSliceRecordingList string           `position:"Query" name:"VoiceSliceRecordingList"`
	ConversationId          string           `position:"Query" name:"ConversationId"`
	StartTime               requests.Integer `position:"Query" name:"StartTime"`
	Type                    string           `position:"Query" name:"Type"`
	Duration                string           `position:"Query" name:"Duration"`
	InstanceId              string           `position:"Query" name:"InstanceId"`
	FileName                string           `position:"Query" name:"FileName"`
	FilePath                string           `position:"Query" name:"FilePath"`
	InstanceOwnerId         requests.Integer `position:"Query" name:"InstanceOwnerId"`
}

// SaveRecordingResponse is the response struct for api SaveRecording
type SaveRecordingResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSaveRecordingRequest creates a request to invoke SaveRecording API
func CreateSaveRecordingRequest() (request *SaveRecordingRequest) {
	request = &SaveRecordingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("VoiceNavigator", "2018-06-12", "SaveRecording", "voicebot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSaveRecordingResponse creates a response to parse from SaveRecording response
func CreateSaveRecordingResponse() (response *SaveRecordingResponse) {
	response = &SaveRecordingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
