package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RestoreMedia invokes the vod.RestoreMedia API synchronously
func (client *Client) RestoreMedia(request *RestoreMediaRequest) (response *RestoreMediaResponse, err error) {
	response = CreateRestoreMediaResponse()
	err = client.DoAction(request, response)
	return
}

// RestoreMediaWithChan invokes the vod.RestoreMedia API asynchronously
func (client *Client) RestoreMediaWithChan(request *RestoreMediaRequest) (<-chan *RestoreMediaResponse, <-chan error) {
	responseChan := make(chan *RestoreMediaResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RestoreMedia(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RestoreMediaWithCallback invokes the vod.RestoreMedia API asynchronously
func (client *Client) RestoreMediaWithCallback(request *RestoreMediaRequest, callback func(response *RestoreMediaResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RestoreMediaResponse
		var err error
		defer close(result)
		response, err = client.RestoreMedia(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RestoreMediaRequest is the request struct for api RestoreMedia
type RestoreMediaRequest struct {
	*requests.RpcRequest
	RestoreTier string `position:"Query" name:"RestoreTier"`
	RestoreDays string `position:"Query" name:"RestoreDays"`
	Scope       string `position:"Query" name:"Scope"`
	MediaIds    string `position:"Query" name:"MediaIds"`
}

// RestoreMediaResponse is the response struct for api RestoreMedia
type RestoreMediaResponse struct {
	*responses.BaseResponse
	RequestId     string                      `json:"RequestId" xml:"RequestId"`
	Success       bool                        `json:"Success" xml:"Success"`
	IgnoredList   IgnoredListInRestoreMedia   `json:"IgnoredList" xml:"IgnoredList"`
	ForbiddenList ForbiddenListInRestoreMedia `json:"ForbiddenList" xml:"ForbiddenList"`
}

// CreateRestoreMediaRequest creates a request to invoke RestoreMedia API
func CreateRestoreMediaRequest() (request *RestoreMediaRequest) {
	request = &RestoreMediaRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "RestoreMedia", "vod", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRestoreMediaResponse creates a response to parse from RestoreMedia response
func CreateRestoreMediaResponse() (response *RestoreMediaResponse) {
	response = &RestoreMediaResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
