package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVodTieringStorageRetrievalData invokes the vod.DescribeVodTieringStorageRetrievalData API synchronously
func (client *Client) DescribeVodTieringStorageRetrievalData(request *DescribeVodTieringStorageRetrievalDataRequest) (response *DescribeVodTieringStorageRetrievalDataResponse, err error) {
	response = CreateDescribeVodTieringStorageRetrievalDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVodTieringStorageRetrievalDataWithChan invokes the vod.DescribeVodTieringStorageRetrievalData API asynchronously
func (client *Client) DescribeVodTieringStorageRetrievalDataWithChan(request *DescribeVodTieringStorageRetrievalDataRequest) (<-chan *DescribeVodTieringStorageRetrievalDataResponse, <-chan error) {
	responseChan := make(chan *DescribeVodTieringStorageRetrievalDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVodTieringStorageRetrievalData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVodTieringStorageRetrievalDataWithCallback invokes the vod.DescribeVodTieringStorageRetrievalData API asynchronously
func (client *Client) DescribeVodTieringStorageRetrievalDataWithCallback(request *DescribeVodTieringStorageRetrievalDataRequest, callback func(response *DescribeVodTieringStorageRetrievalDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVodTieringStorageRetrievalDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeVodTieringStorageRetrievalData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVodTieringStorageRetrievalDataRequest is the request struct for api DescribeVodTieringStorageRetrievalData
type DescribeVodTieringStorageRetrievalDataRequest struct {
	*requests.RpcRequest
	StartTime    string           `position:"Query" name:"StartTime"`
	SplitBy      string           `position:"Query" name:"SplitBy"`
	EndTime      string           `position:"Query" name:"EndTime"`
	OwnerId      requests.Integer `position:"Query" name:"OwnerId"`
	StorageClass string           `position:"Query" name:"StorageClass"`
	Region       string           `position:"Query" name:"Region"`
}

// DescribeVodTieringStorageRetrievalDataResponse is the response struct for api DescribeVodTieringStorageRetrievalData
type DescribeVodTieringStorageRetrievalDataResponse struct {
	*responses.BaseResponse
	RequestId     string              `json:"RequestId" xml:"RequestId"`
	RetrievalData []RetrievalDataItem `json:"RetrievalData" xml:"RetrievalData"`
}

// CreateDescribeVodTieringStorageRetrievalDataRequest creates a request to invoke DescribeVodTieringStorageRetrievalData API
func CreateDescribeVodTieringStorageRetrievalDataRequest() (request *DescribeVodTieringStorageRetrievalDataRequest) {
	request = &DescribeVodTieringStorageRetrievalDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "DescribeVodTieringStorageRetrievalData", "vod", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeVodTieringStorageRetrievalDataResponse creates a response to parse from DescribeVodTieringStorageRetrievalData response
func CreateDescribeVodTieringStorageRetrievalDataResponse() (response *DescribeVodTieringStorageRetrievalDataResponse) {
	response = &DescribeVodTieringStorageRetrievalDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
