package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVodSSLCertificateList invokes the vod.DescribeVodSSLCertificateList API synchronously
func (client *Client) DescribeVodSSLCertificateList(request *DescribeVodSSLCertificateListRequest) (response *DescribeVodSSLCertificateListResponse, err error) {
	response = CreateDescribeVodSSLCertificateListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVodSSLCertificateListWithChan invokes the vod.DescribeVodSSLCertificateList API asynchronously
func (client *Client) DescribeVodSSLCertificateListWithChan(request *DescribeVodSSLCertificateListRequest) (<-chan *DescribeVodSSLCertificateListResponse, <-chan error) {
	responseChan := make(chan *DescribeVodSSLCertificateListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVodSSLCertificateList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVodSSLCertificateListWithCallback invokes the vod.DescribeVodSSLCertificateList API asynchronously
func (client *Client) DescribeVodSSLCertificateListWithCallback(request *DescribeVodSSLCertificateListRequest, callback func(response *DescribeVodSSLCertificateListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVodSSLCertificateListResponse
		var err error
		defer close(result)
		response, err = client.DescribeVodSSLCertificateList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVodSSLCertificateListRequest is the request struct for api DescribeVodSSLCertificateList
type DescribeVodSSLCertificateListRequest struct {
	*requests.RpcRequest
	PageNumber    requests.Integer `position:"Query" name:"PageNumber"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
	PageSize      requests.Integer `position:"Query" name:"PageSize"`
	MatchType     string           `position:"Query" name:"MatchType"`
	Algorithm     string           `position:"Query" name:"Algorithm"`
	DomainName    string           `position:"Query" name:"DomainName"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
	SearchKeyword string           `position:"Query" name:"SearchKeyword"`
}

// DescribeVodSSLCertificateListResponse is the response struct for api DescribeVodSSLCertificateList
type DescribeVodSSLCertificateListResponse struct {
	*responses.BaseResponse
	RequestId            string               `json:"RequestId" xml:"RequestId"`
	CertificateListModel CertificateListModel `json:"CertificateListModel" xml:"CertificateListModel"`
}

// CreateDescribeVodSSLCertificateListRequest creates a request to invoke DescribeVodSSLCertificateList API
func CreateDescribeVodSSLCertificateListRequest() (request *DescribeVodSSLCertificateListRequest) {
	request = &DescribeVodSSLCertificateListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "DescribeVodSSLCertificateList", "vod", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeVodSSLCertificateListResponse creates a response to parse from DescribeVodSSLCertificateList response
func CreateDescribeVodSSLCertificateListResponse() (response *DescribeVodSSLCertificateListResponse) {
	response = &DescribeVodSSLCertificateListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
