package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVodDomainMax95BpsData invokes the vod.DescribeVodDomainMax95BpsData API synchronously
func (client *Client) DescribeVodDomainMax95BpsData(request *DescribeVodDomainMax95BpsDataRequest) (response *DescribeVodDomainMax95BpsDataResponse, err error) {
	response = CreateDescribeVodDomainMax95BpsDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVodDomainMax95BpsDataWithChan invokes the vod.DescribeVodDomainMax95BpsData API asynchronously
func (client *Client) DescribeVodDomainMax95BpsDataWithChan(request *DescribeVodDomainMax95BpsDataRequest) (<-chan *DescribeVodDomainMax95BpsDataResponse, <-chan error) {
	responseChan := make(chan *DescribeVodDomainMax95BpsDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVodDomainMax95BpsData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVodDomainMax95BpsDataWithCallback invokes the vod.DescribeVodDomainMax95BpsData API asynchronously
func (client *Client) DescribeVodDomainMax95BpsDataWithCallback(request *DescribeVodDomainMax95BpsDataRequest, callback func(response *DescribeVodDomainMax95BpsDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVodDomainMax95BpsDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeVodDomainMax95BpsData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVodDomainMax95BpsDataRequest is the request struct for api DescribeVodDomainMax95BpsData
type DescribeVodDomainMax95BpsDataRequest struct {
	*requests.RpcRequest
	StartTime  string           `position:"Query" name:"StartTime"`
	Cycle      string           `position:"Query" name:"Cycle"`
	DomainName string           `position:"Query" name:"DomainName"`
	EndTime    string           `position:"Query" name:"EndTime"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
	TimePoint  string           `position:"Query" name:"TimePoint"`
}

// DescribeVodDomainMax95BpsDataResponse is the response struct for api DescribeVodDomainMax95BpsData
type DescribeVodDomainMax95BpsDataResponse struct {
	*responses.BaseResponse
	RequestId        string     `json:"RequestId" xml:"RequestId"`
	DomainName       string     `json:"DomainName" xml:"DomainName"`
	EndTime          string     `json:"EndTime" xml:"EndTime"`
	StartTime        string     `json:"StartTime" xml:"StartTime"`
	DomesticMax95Bps string     `json:"DomesticMax95Bps" xml:"DomesticMax95Bps"`
	OverseasMax95Bps string     `json:"OverseasMax95Bps" xml:"OverseasMax95Bps"`
	Max95Bps         string     `json:"Max95Bps" xml:"Max95Bps"`
	DetailData       DetailData `json:"DetailData" xml:"DetailData"`
}

// CreateDescribeVodDomainMax95BpsDataRequest creates a request to invoke DescribeVodDomainMax95BpsData API
func CreateDescribeVodDomainMax95BpsDataRequest() (request *DescribeVodDomainMax95BpsDataRequest) {
	request = &DescribeVodDomainMax95BpsDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "DescribeVodDomainMax95BpsData", "vod", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeVodDomainMax95BpsDataResponse creates a response to parse from DescribeVodDomainMax95BpsData response
func CreateDescribeVodDomainMax95BpsDataResponse() (response *DescribeVodDomainMax95BpsDataResponse) {
	response = &DescribeVodDomainMax95BpsDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
