package viapi_regen

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDatasetDatas invokes the viapi_regen.ListDatasetDatas API synchronously
func (client *Client) ListDatasetDatas(request *ListDatasetDatasRequest) (response *ListDatasetDatasResponse, err error) {
	response = CreateListDatasetDatasResponse()
	err = client.DoAction(request, response)
	return
}

// ListDatasetDatasWithChan invokes the viapi_regen.ListDatasetDatas API asynchronously
func (client *Client) ListDatasetDatasWithChan(request *ListDatasetDatasRequest) (<-chan *ListDatasetDatasResponse, <-chan error) {
	responseChan := make(chan *ListDatasetDatasResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDatasetDatas(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDatasetDatasWithCallback invokes the viapi_regen.ListDatasetDatas API asynchronously
func (client *Client) ListDatasetDatasWithCallback(request *ListDatasetDatasRequest, callback func(response *ListDatasetDatasResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDatasetDatasResponse
		var err error
		defer close(result)
		response, err = client.ListDatasetDatas(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDatasetDatasRequest is the request struct for api ListDatasetDatas
type ListDatasetDatasRequest struct {
	*requests.RpcRequest
	Identity    string           `position:"Body" name:"Identity"`
	PageSize    requests.Integer `position:"Body" name:"PageSize"`
	CurrentPage requests.Integer `position:"Body" name:"CurrentPage"`
	DatasetId   requests.Integer `position:"Body" name:"DatasetId"`
}

// ListDatasetDatasResponse is the response struct for api ListDatasetDatas
type ListDatasetDatasResponse struct {
	*responses.BaseResponse
	Message   string                 `json:"Message" xml:"Message"`
	RequestId string                 `json:"RequestId" xml:"RequestId"`
	Code      string                 `json:"Code" xml:"Code"`
	Data      DataInListDatasetDatas `json:"Data" xml:"Data"`
}

// CreateListDatasetDatasRequest creates a request to invoke ListDatasetDatas API
func CreateListDatasetDatasRequest() (request *ListDatasetDatasRequest) {
	request = &ListDatasetDatasRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("viapi-regen", "2021-11-19", "ListDatasetDatas", "selflearning", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListDatasetDatasResponse creates a response to parse from ListDatasetDatas response
func CreateListDatasetDatasResponse() (response *ListDatasetDatasResponse) {
	response = &ListDatasetDatasResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
