package ververica

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetDeploymentResourceMode invokes the ververica.SetDeploymentResourceMode API synchronously
func (client *Client) SetDeploymentResourceMode(request *SetDeploymentResourceModeRequest) (response *SetDeploymentResourceModeResponse, err error) {
	response = CreateSetDeploymentResourceModeResponse()
	err = client.DoAction(request, response)
	return
}

// SetDeploymentResourceModeWithChan invokes the ververica.SetDeploymentResourceMode API asynchronously
func (client *Client) SetDeploymentResourceModeWithChan(request *SetDeploymentResourceModeRequest) (<-chan *SetDeploymentResourceModeResponse, <-chan error) {
	responseChan := make(chan *SetDeploymentResourceModeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetDeploymentResourceMode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetDeploymentResourceModeWithCallback invokes the ververica.SetDeploymentResourceMode API asynchronously
func (client *Client) SetDeploymentResourceModeWithCallback(request *SetDeploymentResourceModeRequest, callback func(response *SetDeploymentResourceModeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetDeploymentResourceModeResponse
		var err error
		defer close(result)
		response, err = client.SetDeploymentResourceMode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetDeploymentResourceModeRequest is the request struct for api SetDeploymentResourceMode
type SetDeploymentResourceModeRequest struct {
	*requests.RoaRequest
	Workspace    string `position:"Path" name:"workspace"`
	ParamsJson   string `position:"Body" name:"paramsJson"`
	DeploymentId string `position:"Path" name:"deploymentId"`
	Namespace    string `position:"Path" name:"namespace"`
}

// SetDeploymentResourceModeResponse is the response struct for api SetDeploymentResourceMode
type SetDeploymentResourceModeResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"success" xml:"success"`
	Data      string `json:"data" xml:"data"`
	RequestId string `json:"requestId" xml:"requestId"`
}

// CreateSetDeploymentResourceModeRequest creates a request to invoke SetDeploymentResourceMode API
func CreateSetDeploymentResourceModeRequest() (request *SetDeploymentResourceModeRequest) {
	request = &SetDeploymentResourceModeRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("ververica", "2020-05-01", "SetDeploymentResourceMode", "/pop/workspaces/[workspace]/api/v1/namespaces/[namespace]/deployments/[deploymentId]/set-resource", "", "")
	request.Method = requests.PUT
	return
}

// CreateSetDeploymentResourceModeResponse creates a response to parse from SetDeploymentResourceMode response
func CreateSetDeploymentResourceModeResponse() (response *SetDeploymentResourceModeResponse) {
	response = &SetDeploymentResourceModeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
