package ververica

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetArtifactMetadata invokes the ververica.GetArtifactMetadata API synchronously
func (client *Client) GetArtifactMetadata(request *GetArtifactMetadataRequest) (response *GetArtifactMetadataResponse, err error) {
	response = CreateGetArtifactMetadataResponse()
	err = client.DoAction(request, response)
	return
}

// GetArtifactMetadataWithChan invokes the ververica.GetArtifactMetadata API asynchronously
func (client *Client) GetArtifactMetadataWithChan(request *GetArtifactMetadataRequest) (<-chan *GetArtifactMetadataResponse, <-chan error) {
	responseChan := make(chan *GetArtifactMetadataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetArtifactMetadata(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetArtifactMetadataWithCallback invokes the ververica.GetArtifactMetadata API asynchronously
func (client *Client) GetArtifactMetadataWithCallback(request *GetArtifactMetadataRequest, callback func(response *GetArtifactMetadataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetArtifactMetadataResponse
		var err error
		defer close(result)
		response, err = client.GetArtifactMetadata(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetArtifactMetadataRequest is the request struct for api GetArtifactMetadata
type GetArtifactMetadataRequest struct {
	*requests.RoaRequest
	Workspace string `position:"Path" name:"workspace"`
	Filename  string `position:"Query" name:"filename"`
	Namespace string `position:"Path" name:"namespace"`
}

// GetArtifactMetadataResponse is the response struct for api GetArtifactMetadata
type GetArtifactMetadataResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"success" xml:"success"`
	RequestId string `json:"requestId" xml:"requestId"`
	Data      string `json:"data" xml:"data"`
}

// CreateGetArtifactMetadataRequest creates a request to invoke GetArtifactMetadata API
func CreateGetArtifactMetadataRequest() (request *GetArtifactMetadataRequest) {
	request = &GetArtifactMetadataRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("ververica", "2020-05-01", "GetArtifactMetadata", "/pop/workspaces/[workspace]/artifacts/v1/namespaces/[namespace]/artifacts:getMetadata", "", "")
	request.Method = requests.GET
	return
}

// CreateGetArtifactMetadataResponse creates a response to parse from GetArtifactMetadata response
func CreateGetArtifactMetadataResponse() (response *GetArtifactMetadataResponse) {
	response = &GetArtifactMetadataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
