package trademark

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CancelTradeOrder invokes the trademark.CancelTradeOrder API synchronously
// api document: https://help.aliyun.com/api/trademark/canceltradeorder.html
func (client *Client) CancelTradeOrder(request *CancelTradeOrderRequest) (response *CancelTradeOrderResponse, err error) {
	response = CreateCancelTradeOrderResponse()
	err = client.DoAction(request, response)
	return
}

// CancelTradeOrderWithChan invokes the trademark.CancelTradeOrder API asynchronously
// api document: https://help.aliyun.com/api/trademark/canceltradeorder.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CancelTradeOrderWithChan(request *CancelTradeOrderRequest) (<-chan *CancelTradeOrderResponse, <-chan error) {
	responseChan := make(chan *CancelTradeOrderResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CancelTradeOrder(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CancelTradeOrderWithCallback invokes the trademark.CancelTradeOrder API asynchronously
// api document: https://help.aliyun.com/api/trademark/canceltradeorder.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CancelTradeOrderWithCallback(request *CancelTradeOrderRequest, callback func(response *CancelTradeOrderResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CancelTradeOrderResponse
		var err error
		defer close(result)
		response, err = client.CancelTradeOrder(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CancelTradeOrderRequest is the request struct for api CancelTradeOrder
type CancelTradeOrderRequest struct {
	*requests.RpcRequest
	BizId string `position:"Query" name:"BizId"`
}

// CancelTradeOrderResponse is the response struct for api CancelTradeOrder
type CancelTradeOrderResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
}

// CreateCancelTradeOrderRequest creates a request to invoke CancelTradeOrder API
func CreateCancelTradeOrderRequest() (request *CancelTradeOrderRequest) {
	request = &CancelTradeOrderRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Trademark", "2018-07-24", "CancelTradeOrder", "trademark", "openAPI")
	return
}

// CreateCancelTradeOrderResponse creates a response to parse from CancelTradeOrder response
func CreateCancelTradeOrderResponse() (response *CancelTradeOrderResponse) {
	response = &CancelTradeOrderResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
