package threedvision

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ReconstructBodyBySingleImage invokes the threedvision.ReconstructBodyBySingleImage API synchronously
func (client *Client) ReconstructBodyBySingleImage(request *ReconstructBodyBySingleImageRequest) (response *ReconstructBodyBySingleImageResponse, err error) {
	response = CreateReconstructBodyBySingleImageResponse()
	err = client.DoAction(request, response)
	return
}

// ReconstructBodyBySingleImageWithChan invokes the threedvision.ReconstructBodyBySingleImage API asynchronously
func (client *Client) ReconstructBodyBySingleImageWithChan(request *ReconstructBodyBySingleImageRequest) (<-chan *ReconstructBodyBySingleImageResponse, <-chan error) {
	responseChan := make(chan *ReconstructBodyBySingleImageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ReconstructBodyBySingleImage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ReconstructBodyBySingleImageWithCallback invokes the threedvision.ReconstructBodyBySingleImage API asynchronously
func (client *Client) ReconstructBodyBySingleImageWithCallback(request *ReconstructBodyBySingleImageRequest, callback func(response *ReconstructBodyBySingleImageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ReconstructBodyBySingleImageResponse
		var err error
		defer close(result)
		response, err = client.ReconstructBodyBySingleImage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ReconstructBodyBySingleImageRequest is the request struct for api ReconstructBodyBySingleImage
type ReconstructBodyBySingleImageRequest struct {
	*requests.RpcRequest
	ImageURL string `position:"Body" name:"ImageURL"`
}

// ReconstructBodyBySingleImageResponse is the response struct for api ReconstructBodyBySingleImage
type ReconstructBodyBySingleImageResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateReconstructBodyBySingleImageRequest creates a request to invoke ReconstructBodyBySingleImage API
func CreateReconstructBodyBySingleImageRequest() (request *ReconstructBodyBySingleImageRequest) {
	request = &ReconstructBodyBySingleImageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("threedvision", "2021-01-31", "ReconstructBodyBySingleImage", "threedvision", "openAPI")
	request.Method = requests.POST
	return
}

// CreateReconstructBodyBySingleImageResponse creates a response to parse from ReconstructBodyBySingleImage response
func CreateReconstructBodyBySingleImageResponse() (response *ReconstructBodyBySingleImageResponse) {
	response = &ReconstructBodyBySingleImageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
