package swas_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateDiskAttribute invokes the swas_open.UpdateDiskAttribute API synchronously
func (client *Client) UpdateDiskAttribute(request *UpdateDiskAttributeRequest) (response *UpdateDiskAttributeResponse, err error) {
	response = CreateUpdateDiskAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateDiskAttributeWithChan invokes the swas_open.UpdateDiskAttribute API asynchronously
func (client *Client) UpdateDiskAttributeWithChan(request *UpdateDiskAttributeRequest) (<-chan *UpdateDiskAttributeResponse, <-chan error) {
	responseChan := make(chan *UpdateDiskAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateDiskAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateDiskAttributeWithCallback invokes the swas_open.UpdateDiskAttribute API asynchronously
func (client *Client) UpdateDiskAttributeWithCallback(request *UpdateDiskAttributeRequest, callback func(response *UpdateDiskAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateDiskAttributeResponse
		var err error
		defer close(result)
		response, err = client.UpdateDiskAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateDiskAttributeRequest is the request struct for api UpdateDiskAttribute
type UpdateDiskAttributeRequest struct {
	*requests.RpcRequest
	ClientToken string `position:"Query" name:"ClientToken"`
	Remark      string `position:"Query" name:"Remark"`
	DiskId      string `position:"Query" name:"DiskId"`
}

// UpdateDiskAttributeResponse is the response struct for api UpdateDiskAttribute
type UpdateDiskAttributeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateDiskAttributeRequest creates a request to invoke UpdateDiskAttribute API
func CreateUpdateDiskAttributeRequest() (request *UpdateDiskAttributeRequest) {
	request = &UpdateDiskAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("SWAS-OPEN", "2020-06-01", "UpdateDiskAttribute", "SWAS-OPEN", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateDiskAttributeResponse creates a response to parse from UpdateDiskAttribute response
func CreateUpdateDiskAttributeResponse() (response *UpdateDiskAttributeResponse) {
	response = &UpdateDiskAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
