package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RoamClientUser invokes the smartag.RoamClientUser API synchronously
func (client *Client) RoamClientUser(request *RoamClientUserRequest) (response *RoamClientUserResponse, err error) {
	response = CreateRoamClientUserResponse()
	err = client.DoAction(request, response)
	return
}

// RoamClientUserWithChan invokes the smartag.RoamClientUser API asynchronously
func (client *Client) RoamClientUserWithChan(request *RoamClientUserRequest) (<-chan *RoamClientUserResponse, <-chan error) {
	responseChan := make(chan *RoamClientUserResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RoamClientUser(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RoamClientUserWithCallback invokes the smartag.RoamClientUser API asynchronously
func (client *Client) RoamClientUserWithCallback(request *RoamClientUserRequest, callback func(response *RoamClientUserResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RoamClientUserResponse
		var err error
		defer close(result)
		response, err = client.RoamClientUser(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RoamClientUserRequest is the request struct for api RoamClientUser
type RoamClientUserRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	OriginSmartAGId      string           `position:"Query" name:"OriginSmartAGId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	TargetSmartAGId      string           `position:"Query" name:"TargetSmartAGId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	OriginRegionId       string           `position:"Query" name:"OriginRegionId"`
	UserName             string           `position:"Query" name:"UserName"`
}

// RoamClientUserResponse is the response struct for api RoamClientUser
type RoamClientUserResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateRoamClientUserRequest creates a request to invoke RoamClientUser API
func CreateRoamClientUserRequest() (request *RoamClientUserRequest) {
	request = &RoamClientUserRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "RoamClientUser", "smartag", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRoamClientUserResponse creates a response to parse from RoamClientUser response
func CreateRoamClientUserResponse() (response *RoamClientUserResponse) {
	response = &RoamClientUserResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
