package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAccessPoints invokes the smartag.ListAccessPoints API synchronously
func (client *Client) ListAccessPoints(request *ListAccessPointsRequest) (response *ListAccessPointsResponse, err error) {
	response = CreateListAccessPointsResponse()
	err = client.DoAction(request, response)
	return
}

// ListAccessPointsWithChan invokes the smartag.ListAccessPoints API asynchronously
func (client *Client) ListAccessPointsWithChan(request *ListAccessPointsRequest) (<-chan *ListAccessPointsResponse, <-chan error) {
	responseChan := make(chan *ListAccessPointsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAccessPoints(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAccessPointsWithCallback invokes the smartag.ListAccessPoints API asynchronously
func (client *Client) ListAccessPointsWithCallback(request *ListAccessPointsRequest, callback func(response *ListAccessPointsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAccessPointsResponse
		var err error
		defer close(result)
		response, err = client.ListAccessPoints(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAccessPointsRequest is the request struct for api ListAccessPoints
type ListAccessPointsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PageNumber           requests.Integer `position:"Query" name:"PageNumber"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	SmartAGId            string           `position:"Query" name:"SmartAGId"`
}

// ListAccessPointsResponse is the response struct for api ListAccessPoints
type ListAccessPointsResponse struct {
	*responses.BaseResponse
	TotalCount   int           `json:"TotalCount" xml:"TotalCount"`
	RequestId    string        `json:"RequestId" xml:"RequestId"`
	AccessPoints []AccessPoint `json:"AccessPoints" xml:"AccessPoints"`
}

// CreateListAccessPointsRequest creates a request to invoke ListAccessPoints API
func CreateListAccessPointsRequest() (request *ListAccessPointsRequest) {
	request = &ListAccessPointsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "ListAccessPoints", "smartag", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListAccessPointsResponse creates a response to parse from ListAccessPoints response
func CreateListAccessPointsResponse() (response *ListAccessPointsResponse) {
	response = &ListAccessPointsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
