package scsp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateSkillGroup invokes the scsp.CreateSkillGroup API synchronously
func (client *Client) CreateSkillGroup(request *CreateSkillGroupRequest) (response *CreateSkillGroupResponse, err error) {
	response = CreateCreateSkillGroupResponse()
	err = client.DoAction(request, response)
	return
}

// CreateSkillGroupWithChan invokes the scsp.CreateSkillGroup API asynchronously
func (client *Client) CreateSkillGroupWithChan(request *CreateSkillGroupRequest) (<-chan *CreateSkillGroupResponse, <-chan error) {
	responseChan := make(chan *CreateSkillGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateSkillGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateSkillGroupWithCallback invokes the scsp.CreateSkillGroup API asynchronously
func (client *Client) CreateSkillGroupWithCallback(request *CreateSkillGroupRequest, callback func(response *CreateSkillGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateSkillGroupResponse
		var err error
		defer close(result)
		response, err = client.CreateSkillGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateSkillGroupRequest is the request struct for api CreateSkillGroup
type CreateSkillGroupRequest struct {
	*requests.RpcRequest
	InstanceId     string           `position:"Body"`
	ClientToken    string           `position:"Body"`
	DisplayName    string           `position:"Body"`
	ChannelType    requests.Integer `position:"Body"`
	SkillGroupName string           `position:"Body"`
	Description    string           `position:"Body"`
}

// CreateSkillGroupResponse is the response struct for api CreateSkillGroup
type CreateSkillGroupResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      int64  `json:"Data" xml:"Data"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateCreateSkillGroupRequest creates a request to invoke CreateSkillGroup API
func CreateCreateSkillGroupRequest() (request *CreateSkillGroupRequest) {
	request = &CreateSkillGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scsp", "2020-07-02", "CreateSkillGroup", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateSkillGroupResponse creates a response to parse from CreateSkillGroup response
func CreateCreateSkillGroupResponse() (response *CreateSkillGroupResponse) {
	response = &CreateSkillGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
