package scsp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateAgent invokes the scsp.CreateAgent API synchronously
func (client *Client) CreateAgent(request *CreateAgentRequest) (response *CreateAgentResponse, err error) {
	response = CreateCreateAgentResponse()
	err = client.DoAction(request, response)
	return
}

// CreateAgentWithChan invokes the scsp.CreateAgent API asynchronously
func (client *Client) CreateAgentWithChan(request *CreateAgentRequest) (<-chan *CreateAgentResponse, <-chan error) {
	responseChan := make(chan *CreateAgentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateAgent(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateAgentWithCallback invokes the scsp.CreateAgent API asynchronously
func (client *Client) CreateAgentWithCallback(request *CreateAgentRequest, callback func(response *CreateAgentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateAgentResponse
		var err error
		defer close(result)
		response, err = client.CreateAgent(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateAgentRequest is the request struct for api CreateAgent
type CreateAgentRequest struct {
	*requests.RpcRequest
	ClientToken      string                         `position:"Body"`
	InstanceId       string                         `position:"Body"`
	AccountName      string                         `position:"Body"`
	DisplayName      string                         `position:"Body"`
	SkillGroupId     *[]CreateAgentSkillGroupId     `position:"Body" name:"SkillGroupId"  type:"Repeated"`
	SkillGroupIdList *[]CreateAgentSkillGroupIdList `position:"Body" name:"SkillGroupIdList"  type:"Repeated"`
}

// CreateAgentSkillGroupId is a repeated param struct in CreateAgentRequest
type CreateAgentSkillGroupId struct {
	SkillGroupId string `name:"SkillGroupId"`
}

// CreateAgentSkillGroupIdList is a repeated param struct in CreateAgentRequest
type CreateAgentSkillGroupIdList struct {
	SkillGroupIdList string `name:"SkillGroupIdList"`
}

// CreateAgentResponse is the response struct for api CreateAgent
type CreateAgentResponse struct {
	*responses.BaseResponse
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Data           int64  `json:"Data" xml:"Data"`
	Code           string `json:"Code" xml:"Code"`
	Success        bool   `json:"Success" xml:"Success"`
	HttpStatusCode int64  `json:"HttpStatusCode" xml:"HttpStatusCode"`
}

// CreateCreateAgentRequest creates a request to invoke CreateAgent API
func CreateCreateAgentRequest() (request *CreateAgentRequest) {
	request = &CreateAgentRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scsp", "2020-07-02", "CreateAgent", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateAgentResponse creates a response to parse from CreateAgent response
func CreateCreateAgentResponse() (response *CreateAgentResponse) {
	response = &CreateAgentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
