package sasti

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeIpReport invokes the sasti.DescribeIpReport API synchronously
func (client *Client) DescribeIpReport(request *DescribeIpReportRequest) (response *DescribeIpReportResponse, err error) {
	response = CreateDescribeIpReportResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeIpReportWithChan invokes the sasti.DescribeIpReport API asynchronously
func (client *Client) DescribeIpReportWithChan(request *DescribeIpReportRequest) (<-chan *DescribeIpReportResponse, <-chan error) {
	responseChan := make(chan *DescribeIpReportResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeIpReport(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeIpReportWithCallback invokes the sasti.DescribeIpReport API asynchronously
func (client *Client) DescribeIpReportWithCallback(request *DescribeIpReportRequest, callback func(response *DescribeIpReportResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeIpReportResponse
		var err error
		defer close(result)
		response, err = client.DescribeIpReport(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeIpReportRequest is the request struct for api DescribeIpReport
type DescribeIpReportRequest struct {
	*requests.RpcRequest
	SourceIp    string `position:"Query" name:"SourceIp"`
	Ip          string `position:"Query" name:"Ip"`
	Field       string `position:"Query" name:"Field"`
	ServiceLang string `position:"Query" name:"ServiceLang"`
}

// DescribeIpReportResponse is the response struct for api DescribeIpReport
type DescribeIpReportResponse struct {
	*responses.BaseResponse
	Context               string `json:"Context" xml:"Context"`
	Intelligences         string `json:"Intelligences" xml:"Intelligences"`
	Whois                 string `json:"Whois" xml:"Whois"`
	RequestId             string `json:"RequestId" xml:"RequestId"`
	AttackPreferenceTop5  string `json:"AttackPreferenceTop5" xml:"AttackPreferenceTop5"`
	Confidence            string `json:"Confidence" xml:"Confidence"`
	ThreatTypes           string `json:"ThreatTypes" xml:"ThreatTypes"`
	Scenario              string `json:"Scenario" xml:"Scenario"`
	Ip                    string `json:"Ip" xml:"Ip"`
	ThreatLevel           string `json:"ThreatLevel" xml:"ThreatLevel"`
	AttackCntByThreatType string `json:"AttackCntByThreatType" xml:"AttackCntByThreatType"`
	Group                 string `json:"Group" xml:"Group"`
}

// CreateDescribeIpReportRequest creates a request to invoke DescribeIpReport API
func CreateDescribeIpReportRequest() (request *DescribeIpReportRequest) {
	request = &DescribeIpReportRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sasti", "2020-05-12", "DescribeIpReport", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeIpReportResponse creates a response to parse from DescribeIpReport response
func CreateDescribeIpReportResponse() (response *DescribeIpReportResponse) {
	response = &DescribeIpReportResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
