package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVendorList invokes the sas.DescribeVendorList API synchronously
func (client *Client) DescribeVendorList(request *DescribeVendorListRequest) (response *DescribeVendorListResponse, err error) {
	response = CreateDescribeVendorListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVendorListWithChan invokes the sas.DescribeVendorList API asynchronously
func (client *Client) DescribeVendorListWithChan(request *DescribeVendorListRequest) (<-chan *DescribeVendorListResponse, <-chan error) {
	responseChan := make(chan *DescribeVendorListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVendorList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVendorListWithCallback invokes the sas.DescribeVendorList API asynchronously
func (client *Client) DescribeVendorListWithCallback(request *DescribeVendorListRequest, callback func(response *DescribeVendorListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVendorListResponse
		var err error
		defer close(result)
		response, err = client.DescribeVendorList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVendorListRequest is the request struct for api DescribeVendorList
type DescribeVendorListRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
}

// DescribeVendorListResponse is the response struct for api DescribeVendorList
type DescribeVendorListResponse struct {
	*responses.BaseResponse
	RequestId      string   `json:"RequestId" xml:"RequestId"`
	VendorNameList []string `json:"VendorNameList" xml:"VendorNameList"`
}

// CreateDescribeVendorListRequest creates a request to invoke DescribeVendorList API
func CreateDescribeVendorListRequest() (request *DescribeVendorListRequest) {
	request = &DescribeVendorListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "DescribeVendorList", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeVendorListResponse creates a response to parse from DescribeVendorList response
func CreateDescribeVendorListResponse() (response *DescribeVendorListResponse) {
	response = &DescribeVendorListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
