package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDomainList invokes the sas.DescribeDomainList API synchronously
func (client *Client) DescribeDomainList(request *DescribeDomainListRequest) (response *DescribeDomainListResponse, err error) {
	response = CreateDescribeDomainListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDomainListWithChan invokes the sas.DescribeDomainList API asynchronously
func (client *Client) DescribeDomainListWithChan(request *DescribeDomainListRequest) (<-chan *DescribeDomainListResponse, <-chan error) {
	responseChan := make(chan *DescribeDomainListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDomainList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDomainListWithCallback invokes the sas.DescribeDomainList API asynchronously
func (client *Client) DescribeDomainListWithCallback(request *DescribeDomainListRequest, callback func(response *DescribeDomainListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDomainListResponse
		var err error
		defer close(result)
		response, err = client.DescribeDomainList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDomainListRequest is the request struct for api DescribeDomainList
type DescribeDomainListRequest struct {
	*requests.RpcRequest
	CurrentPage requests.Integer `position:"Query" name:"CurrentPage"`
	FuzzyDomain string           `position:"Query" name:"FuzzyDomain"`
	SourceIp    string           `position:"Query" name:"SourceIp"`
	DomainType  string           `position:"Query" name:"DomainType"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
}

// DescribeDomainListResponse is the response struct for api DescribeDomainList
type DescribeDomainListResponse struct {
	*responses.BaseResponse
	RequestId              string           `json:"RequestId" xml:"RequestId"`
	PageInfo               PageInfo         `json:"PageInfo" xml:"PageInfo"`
	DomainListResponseList []DomainResponse `json:"DomainListResponseList" xml:"DomainListResponseList"`
}

// CreateDescribeDomainListRequest creates a request to invoke DescribeDomainList API
func CreateDescribeDomainListRequest() (request *DescribeDomainListRequest) {
	request = &DescribeDomainListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "DescribeDomainList", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDomainListResponse creates a response to parse from DescribeDomainList response
func CreateDescribeDomainListResponse() (response *DescribeDomainListResponse) {
	response = &DescribeDomainListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
