package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddVpcHoneyPot invokes the sas.AddVpcHoneyPot API synchronously
func (client *Client) AddVpcHoneyPot(request *AddVpcHoneyPotRequest) (response *AddVpcHoneyPotResponse, err error) {
	response = CreateAddVpcHoneyPotResponse()
	err = client.DoAction(request, response)
	return
}

// AddVpcHoneyPotWithChan invokes the sas.AddVpcHoneyPot API asynchronously
func (client *Client) AddVpcHoneyPotWithChan(request *AddVpcHoneyPotRequest) (<-chan *AddVpcHoneyPotResponse, <-chan error) {
	responseChan := make(chan *AddVpcHoneyPotResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddVpcHoneyPot(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddVpcHoneyPotWithCallback invokes the sas.AddVpcHoneyPot API asynchronously
func (client *Client) AddVpcHoneyPotWithCallback(request *AddVpcHoneyPotRequest, callback func(response *AddVpcHoneyPotResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddVpcHoneyPotResponse
		var err error
		defer close(result)
		response, err = client.AddVpcHoneyPot(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddVpcHoneyPotRequest is the request struct for api AddVpcHoneyPot
type AddVpcHoneyPotRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
	VpcId    string `position:"Query" name:"VpcId"`
}

// AddVpcHoneyPotResponse is the response struct for api AddVpcHoneyPot
type AddVpcHoneyPotResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAddVpcHoneyPotRequest creates a request to invoke AddVpcHoneyPot API
func CreateAddVpcHoneyPotRequest() (request *AddVpcHoneyPotRequest) {
	request = &AddVpcHoneyPotRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "AddVpcHoneyPot", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddVpcHoneyPotResponse creates a response to parse from AddVpcHoneyPot response
func CreateAddVpcHoneyPotResponse() (response *AddVpcHoneyPotResponse) {
	response = &AddVpcHoneyPotResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
