package retailcloud

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateAppMonitors invokes the retailcloud.UpdateAppMonitors API synchronously
func (client *Client) UpdateAppMonitors(request *UpdateAppMonitorsRequest) (response *UpdateAppMonitorsResponse, err error) {
	response = CreateUpdateAppMonitorsResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateAppMonitorsWithChan invokes the retailcloud.UpdateAppMonitors API asynchronously
func (client *Client) UpdateAppMonitorsWithChan(request *UpdateAppMonitorsRequest) (<-chan *UpdateAppMonitorsResponse, <-chan error) {
	responseChan := make(chan *UpdateAppMonitorsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateAppMonitors(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateAppMonitorsWithCallback invokes the retailcloud.UpdateAppMonitors API asynchronously
func (client *Client) UpdateAppMonitorsWithCallback(request *UpdateAppMonitorsRequest, callback func(response *UpdateAppMonitorsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateAppMonitorsResponse
		var err error
		defer close(result)
		response, err = client.UpdateAppMonitors(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateAppMonitorsRequest is the request struct for api UpdateAppMonitors
type UpdateAppMonitorsRequest struct {
	*requests.RpcRequest
	MainUserId  requests.Integer `position:"Body" name:"MainUserId"`
	SilenceTime string           `position:"Body" name:"SilenceTime"`
	MonitorIds  *[]string        `position:"Body" name:"MonitorIds"  type:"Repeated"`
	TemplateId  requests.Integer `position:"Body" name:"TemplateId"`
}

// UpdateAppMonitorsResponse is the response struct for api UpdateAppMonitors
type UpdateAppMonitorsResponse struct {
	*responses.BaseResponse
	Msg       string `json:"Msg" xml:"Msg"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateAppMonitorsRequest creates a request to invoke UpdateAppMonitors API
func CreateUpdateAppMonitorsRequest() (request *UpdateAppMonitorsRequest) {
	request = &UpdateAppMonitorsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailcloud", "2018-03-13", "UpdateAppMonitors", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateAppMonitorsResponse creates a response to parse from UpdateAppMonitors response
func CreateUpdateAppMonitorsResponse() (response *UpdateAppMonitorsResponse) {
	response = &UpdateAppMonitorsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
