package retailcloud

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAppEnvironment invokes the retailcloud.ListAppEnvironment API synchronously
func (client *Client) ListAppEnvironment(request *ListAppEnvironmentRequest) (response *ListAppEnvironmentResponse, err error) {
	response = CreateListAppEnvironmentResponse()
	err = client.DoAction(request, response)
	return
}

// ListAppEnvironmentWithChan invokes the retailcloud.ListAppEnvironment API asynchronously
func (client *Client) ListAppEnvironmentWithChan(request *ListAppEnvironmentRequest) (<-chan *ListAppEnvironmentResponse, <-chan error) {
	responseChan := make(chan *ListAppEnvironmentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAppEnvironment(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAppEnvironmentWithCallback invokes the retailcloud.ListAppEnvironment API asynchronously
func (client *Client) ListAppEnvironmentWithCallback(request *ListAppEnvironmentRequest, callback func(response *ListAppEnvironmentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAppEnvironmentResponse
		var err error
		defer close(result)
		response, err = client.ListAppEnvironment(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAppEnvironmentRequest is the request struct for api ListAppEnvironment
type ListAppEnvironmentRequest struct {
	*requests.RpcRequest
	EnvName    string           `position:"Query" name:"EnvName"`
	AppId      requests.Integer `position:"Query" name:"AppId"`
	EnvType    requests.Integer `position:"Query" name:"EnvType"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
}

// ListAppEnvironmentResponse is the response struct for api ListAppEnvironment
type ListAppEnvironmentResponse struct {
	*responses.BaseResponse
	Code       int                      `json:"Code" xml:"Code"`
	PageNumber int                      `json:"PageNumber" xml:"PageNumber"`
	RequestId  string                   `json:"RequestId" xml:"RequestId"`
	PageSize   int                      `json:"PageSize" xml:"PageSize"`
	TotalCount int64                    `json:"TotalCount" xml:"TotalCount"`
	ErrorMsg   string                   `json:"ErrorMsg" xml:"ErrorMsg"`
	Data       []AppEnvironmentResponse `json:"Data" xml:"Data"`
}

// CreateListAppEnvironmentRequest creates a request to invoke ListAppEnvironment API
func CreateListAppEnvironmentRequest() (request *ListAppEnvironmentRequest) {
	request = &ListAppEnvironmentRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailcloud", "2018-03-13", "ListAppEnvironment", "", "")
	request.Method = requests.GET
	return
}

// CreateListAppEnvironmentResponse creates a response to parse from ListAppEnvironment response
func CreateListAppEnvironmentResponse() (response *ListAppEnvironmentResponse) {
	response = &ListAppEnvironmentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
