package retailcloud

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAppMonitorMetric invokes the retailcloud.DescribeAppMonitorMetric API synchronously
func (client *Client) DescribeAppMonitorMetric(request *DescribeAppMonitorMetricRequest) (response *DescribeAppMonitorMetricResponse, err error) {
	response = CreateDescribeAppMonitorMetricResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAppMonitorMetricWithChan invokes the retailcloud.DescribeAppMonitorMetric API asynchronously
func (client *Client) DescribeAppMonitorMetricWithChan(request *DescribeAppMonitorMetricRequest) (<-chan *DescribeAppMonitorMetricResponse, <-chan error) {
	responseChan := make(chan *DescribeAppMonitorMetricResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAppMonitorMetric(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAppMonitorMetricWithCallback invokes the retailcloud.DescribeAppMonitorMetric API asynchronously
func (client *Client) DescribeAppMonitorMetricWithCallback(request *DescribeAppMonitorMetricRequest, callback func(response *DescribeAppMonitorMetricResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAppMonitorMetricResponse
		var err error
		defer close(result)
		response, err = client.DescribeAppMonitorMetric(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAppMonitorMetricRequest is the request struct for api DescribeAppMonitorMetric
type DescribeAppMonitorMetricRequest struct {
	*requests.RpcRequest
	DeployOrderId string           `position:"Query" name:"DeployOrderId"`
	Metric        string           `position:"Query" name:"Metric"`
	AppId         requests.Integer `position:"Query" name:"AppId"`
	PodName       string           `position:"Query" name:"PodName"`
	EndTime       requests.Integer `position:"Query" name:"EndTime"`
	EnvId         requests.Integer `position:"Query" name:"EnvId"`
	StartTime     requests.Integer `position:"Query" name:"StartTime"`
	Type          string           `position:"Query" name:"Type"`
}

// DescribeAppMonitorMetricResponse is the response struct for api DescribeAppMonitorMetric
type DescribeAppMonitorMetricResponse struct {
	*responses.BaseResponse
	Code      int          `json:"Code" xml:"Code"`
	ErrMsg    string       `json:"ErrMsg" xml:"ErrMsg"`
	RequestId string       `json:"RequestId" xml:"RequestId"`
	Success   bool         `json:"Success" xml:"Success"`
	Result    []MetricItem `json:"Result" xml:"Result"`
}

// CreateDescribeAppMonitorMetricRequest creates a request to invoke DescribeAppMonitorMetric API
func CreateDescribeAppMonitorMetricRequest() (request *DescribeAppMonitorMetricRequest) {
	request = &DescribeAppMonitorMetricRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailcloud", "2018-03-13", "DescribeAppMonitorMetric", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeAppMonitorMetricResponse creates a response to parse from DescribeAppMonitorMetric response
func CreateDescribeAppMonitorMetricResponse() (response *DescribeAppMonitorMetricResponse) {
	response = &DescribeAppMonitorMetricResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
